<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model bitcream\gmvricambi\custom\backend\models\GMVCustomer */

$this->title = $model->name;
$this->params['breadcrumbs'][] = ['label' => Yii::t('gmv', 'Gmv Customers'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="gmvcustomer-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'customer_cod',
            'name',
            'address',
            'postal_code',
            'province_cod',
            'province',
            'nation_cod',
            'nation',
            'promotions_email:email',
            'business_zone_cod',
            'business_zone',
            'payment_term_cod',
            'payment_term',
            'bank_credit_limit',
            'return_terms_cod',
            'return_port_terms_cod',
            'return_port',
            'withdrawal_terms_cod',
            'withdrawal_carrier_cod',
            'withdrawar_carrier',
            'shipping_address_cod',
            'price_list_cod',
            'vat_number',
            'rating_cod',
        ],
    ]) ?>

</div>
