<?php 
use yii\bootstrap\Modal;
use kartik\select2\Select2;
use yii\helpers\ArrayHelper;
use yii\widgets\ActiveForm;
use yii\helpers\Html;
use bitcream\gmvricambi\custom\common\models\OrderItem;

Modal::begin([
            'header' => '<h2 class="modal-title">'.Yii::t('gmv', 'Are you sure to confirm the order?').'</h2>',
            'id'     => 'modal-confirm',
        ]); ?>

            <?php $form = ActiveForm::begin([
                    'action' => ['confirm', 'id' => $model->id],
                    'method' => 'post', 
                ]
            ); ?>

                <h4><?=Yii::t('gmv','Once the order has been confirmed, you not be able to change the order!')?></h4><br>
                <div class="row">
                    <div class="col-sm-6">
                        <b><?=Yii::t('gmv','Shipping address')?></b>
                        <br><p><?=$model->address.' '.$model->province.' '.$model->postal_code?></p>
                    </div>
                    <div class="col-sm-6">
                        <b><?=Yii::t('gmv','Order date')?></b>
                        <br><p><?=date("d/m/Y", $model->order_date)?></p>
                    </div>
                </div>
                <?php if($model->order_status != "quoted" && $model->shipping_term != "02"){?>
                <div class="row">
                    <div class="col-sm-12">
                        <?php if($model->hasOverWeight()){?>
                            <div class='row'>
                                <div class='col-md-12'>
                                <p class="alert_message"><?=Yii::t('gmv','ATTENTION! Overweight')?></p>
                                </div>
                            </div>
                        <?php }?>
                        <?php if($model->hasBulkyProduct()){?>
                            <p class='alert_message'><?=Yii::t('gmv','In the cart there are bulky items you will be contacted by GMV for a quote on the shipping costs of these items:')?><br>
                                <?php foreach($model->bulkyProducts() as $bulkyProduct){
                                    echo $bulkyProduct."<br>";
                                }?>
                            </p>
                        <?php } ?>
                    </div>
                </div>
                <?php }?>
                <br>
                <?php if($model->canBeConfirmed() || $model->shipping_term == "02"){
                    echo $this->render('_modal_can_be_confirmed',[
                        'model' => $model,
                        'paymentMethods' => $paymentMethods,
                    ]);
                }else{ ?>
                    <div class="right-align">
                        <?=Html::a(Yii::t('gmv','Request a quote'), ['to-quote-order','id' => $model->id], ['class' => 'btn btn-success', 'id' => 'quote-order'])?>
                    </div>
                <?php }?>

            <?php ActiveForm::end(); ?>

        <?php Modal::end(); ?>