<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use bitcream\gmvricambi\custom\common\widget\ActionWidget;
use bitcream\gmvricambi\custom\common\models\OrderItem;
use yii\helpers\Url;
use yii\bootstrap\Modal;
/* @var $this yii\web\View */
/* @var $model bitcream\gmvricambi\custom\backend\models\Order */
bitcream\gmvricambi\custom\backend\Asset::register($this);
$this->title = $model->name;
$this->params['breadcrumbs'][] = ['label' => Yii::t('gmv', 'Orders'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
$searchOrderItem = OrderItem::searchShippingOrderItem("Shipping Cost", $model);
\bitcream\gmvricambi\custom\backend\Asset::register($this);
?>
<div class="order-view">

    <h1><?= Html::encode($this->title) ?></h1>
    <?php
        $actionButtons =  [
            [
                'type' => 'create',
            ],
            [
                'type' => 'update',
            ],
            [
                'type' => 'custom-modal',
                'title' => Yii::t('gmv', ($searchOrderItem)? 'Update shipping cost': 'Add shipping cost'),
                'id' => 'add-quotation-shipping-cost-modal',
                'warning-level' => 'success',
                'class' => (!$model->status = "to_quote")? 'hide': 'add-quotation',
            ],  
            [
                'type' => 'delete',
            ],
            [
                'type' => 'print',
            ],
        ];
        echo ActionWidget::widget(['model' => $model, 'customButtons' => $actionButtons, 'categoryMessage' => 'gmv']);
    ?>
    <?php
    if($model->order_status == "to_quote"){?>
        <p class="alert_message"><?=Yii::t('gmv','ATTENTION! The cart contains at least one item for which a specific quotation of the shipping costs is required.')?></p>
    <?php
        
        echo $this->render('_modal_quotation',[
            'model' => $model,
            'shipping_cost' => ($searchOrderItem)? $searchOrderItem->product_price : ''
        ]);
    }
    ?>

    <?php Modal::begin([
        'header' => '<h2 class="modal-title">'.Yii::t('gmv', 'ATTENTION!').'<div class="article_cod"></div><br><div class="article_name"></div></h2>',
        'id'     => 'modal-cost',
    ]); ?>
    <div class='row'>
        <div class='col-md-12'>
            <p><?=Yii::t('gmv','One of the products exceeds 100kg it is not possible to calculate the shipping cost.')?></p>
        </div>
    </div>
    <?php Modal::end(); ?>
    <input type="hidden" id="order_id" name="order_id" value="<?=$model->id?>">
    <input type="hidden" id="nation_cod" name="nation_cod" value="<?=$nationCod?>">
    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'id',
            'name',
            [
                'label'  => Yii::t('gmv','Order date'),
                'value'  =>  date("d/m/Y", $model->order_date)
            ],
            'address',
            'locality',
            'province',
            'postal_code',
            'country',
            'shipping_address',
            [
                'label'  => Yii::t('gmv','Delivery date'),
                'value'  =>  date("d/m/Y", $model->delivery_date)
            ],
            'customer_cod',
            [
                'label'  => Yii::t('gmv','Plant reference'),
                'value'  =>  (!empty($model->plant_reference))? json_encode(unserialize($model->plant_reference)) : Yii::t('gmv','Missing plant code'),
                'contentOptions' => ['class' => (empty($model->plant_reference))? 'plant_message': ''],
            ],
            'order_reference',
            'courier_subscription_code',
            'total',
            'shipping_term',  
            [
                'label'  => Yii::t('gmv','Confirm date'),
                'value'  =>  date("d/m/Y", $model->confirm_date)
            ],
        ],
    ]) ?>

    <?= $this->render('_datatable-orderitem',[
            'searchModel' => $searchModelOrderItem,
            'dataProvider' => $dataProviderOrderItem,
    ]) ?>

</div>
