<?php

namespace bitcream\gmvricambi\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%category}}".
 *
 * @property int $id
 * @property string|null $name
 * @property string|null $slug
 * @property string|null $description
 * @property int|null $status
 * @property string|null $created_at
 * @property int|null $created_user_id
 * @property string|null $updated_at
 * @property int|null $updated_user_id
 * @property int|null $articles_category_id
 *
 * @property GMVArticlesCategory $articlesCategory
 */
class Category extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%category}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['description'], 'string'],
            [['status', 'created_user_id', 'updated_user_id', 'articles_category_id'], 'integer'],
            [['name', 'slug', 'created_at', 'updated_at'], 'string', 'max' => 255],
            [['articles_category_id'], 'exist', 'skipOnError' => true, 'targetClass' => GMVArticlesCategory::className(), 'targetAttribute' => ['articles_category_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('gmv', 'ID'),
            'name' => Yii::t('gmv', 'Name'),
            'slug' => Yii::t('gmv', 'Slug'),
            'description' => Yii::t('gmv', 'Description'),
            'status' => Yii::t('gmv', 'Status'),
            'created_at' => Yii::t('gmv', 'Created At'),
            'created_user_id' => Yii::t('gmv', 'Created User ID'),
            'updated_at' => Yii::t('gmv', 'Updated At'),
            'updated_user_id' => Yii::t('gmv', 'Updated User ID'),
            'articles_category_id' => Yii::t('gmv', 'Articles Category ID'),
        ];
    }

    /**
     * Gets query for [[ArticlesCategory]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getArticlesCategory()
    {
        return $this->hasOne(GMVArticlesCategory::className(), ['id' => 'articles_category_id']);
    }

     /** 
    * Gets query for [[Products]]. 
    * 
    * @return \yii\db\ActiveQuery 
    */ 
   public function getProducts() 
   { 
       return $this->hasMany(Product::className(), ['category_id' => 'id']); 
   } 
}
