<?php

namespace bitcream\gmvricambi\custom\backend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use bitcream\gmvricambi\custom\backend\models\GMVAssembliesParts;

/**
 * GMVAssembliesPartsSearch represents the model behind the search form of `bitcream\gmvricambi\custom\backend\models\GMVAssembliesParts`.
 */
class GMVAssembliesPartsSearch extends GMVAssembliesParts
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['Assembly_ID', 'Assembly_Part', 'PosX', 'PosY'], 'integer'],
            [['Assembly_Label', 'PartName'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = GMVAssembliesParts::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'Assembly_ID' => $this->Assembly_ID,
            'Assembly_Part' => $this->Assembly_Part,
            'PosX' => $this->PosX,
            'PosY' => $this->PosY,
        ]);

        $query->andFilterWhere(['like', 'Assembly_Label', $this->Assembly_Label])
            ->andFilterWhere(['like', 'PartName', $this->PartName]);


            

        return $dataProvider;
    }
}
