<?php

namespace bitcream\gmvricambi\custom\backend\models;

use Yii;
use bitcream\gmvricambi\custom\common\behaviors\StatusBehaviors;
use bitcream\gmvricambi\custom\common\behaviors\CreateUpdateBehaviors;
use yii2tech\ar\softdelete\SoftDeleteBehavior;
use bitcream\gmvricambi\custom\common\models\CustomerUser;
use bitcream\gmvricambi\custom\common\models\GMVArticlePriceList;
use yii\behaviors\SluggableBehavior;

/**
 * This is the model class for table "{{%order_item}}".
 *
 */
class OrderItem extends \bitcream\gmvricambi\custom\common\models\OrderItem
{
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            'softDeleteBehavior' => [
                'class' => SoftDeleteBehavior::className(),
                'softDeleteAttributeValues' => [
                    'status' => 0
                ],
                'replaceRegularDelete' => true // mutate native `delete()` method
            ],
            'status' => [
                'class' => StatusBehaviors::className(),
            ],
            'create-update' => [
                'class' => CreateUpdateBehaviors::className(),
            ],
            [
                'class' => SluggableBehavior::class,
                'attribute' => 'name',
                'slugAttribute' => 'slug',
            ]
        ]);
    }

    public function addOrderItem($articleCod, $orderItemPost, $plantCode = NULL){

        $customerUser = CustomerUser::findOne(Yii::$app->user->id);
        $order = Order::findOne($customerUser->getActiveOrder()->id);

        $GMVArticle = GMVArticle::findOne($articleCod);
        $orderItem = OrderItem::searchOrderItem($articleCod, $order, $plantCode);
        if((!$orderItem || (!empty($orderItemPost['dimension']))) || ($orderItem && $orderItem->plant_code != $plantCode)){
            $orderItem = new OrderItem();
            $orderItem->order_id = $order->id;
            $orderItem->article_cod = $articleCod;
            $orderItem->plant_code = $plantCode;
            $orderItem->quantity = (float)$orderItemPost['quantity'];
            $orderItem->dimension = (!empty($orderItemPost['dimension']))? (float)$orderItemPost['dimension'] : NULL;
            $orderItem->orderitem_status = "30";
            $orderItem->slug = strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $orderItem->name)));

            $products = Product::find()->where(['article_cod' => $articleCod, 'status' => '30'])->all();
            $language = $customerUser->customer->language;
            if(!empty($products) && !empty($language)){
                $productTranslated = Language::getTranslation($language, $products);
            }
            $orderItem->name = (isset($productTranslated))? $productTranslated->name : $GMVArticle->description;
        }else{
            $orderItem->quantity = $orderItem->quantity + (float)$orderItemPost['quantity'];
        }
        $resultSave = $orderItem->save();

        $orderItem->updatePrices();
        $result = [
            "result" => $resultSave,
        ];
        return $result;
    }

    public function updateQuantityOrder($orderItem){
        if(isset($orderItem['dimension'])){
            $this->dimension = $orderItem['dimension'];
        }
        if(isset($orderItem['quantity'])){
            $this->quantity = $orderItem['quantity'];
        }
        if(isset($orderItem['plant_code'])){
            $this->plant_code = $orderItem['plant_code'];
        }
        if(isset($orderItem['note'])){
            $this->note = $orderItem['note'];
        }
        $result = $this->save();
        $this->updatePrices();
        return $result;

    }
}
