<?php
use yii\helpers\Html;
use yii\bootstrap\Modal;
use yii\widgets\ActiveForm;

use kartik\touchspin\TouchSpin;
use kartik\number\NumberControl;
use kartik\select2\Select2;
use bitcream\gmvricambi\custom\common\widget\AddPlantCodeWidget;

\yii\web\YiiAsset::register($this);
?>
<?php Modal::begin([
    'header' => '<h2 class="modal-title">'.Yii::t('gmv', 'Add product assembled').'<div class="article_name"></div></h2>',
    'id'     => 'modal-add-product-assembled',
]); ?>
    <?php $form = ActiveForm::begin([
        'action' => ['add-product-assembled-action-modal'],
        'method' => 'post',
        'id' => 'form-add-product-assembled'
    ]);
    ?>
    <div class='row'>
        <div class='col-md-12'>
            <input type="hidden" id="AssemblyName" name="GMVArticle[AssemblyName]" value="">
            <div class='row'>
                <div class='quantity_block col-md-12'>
                    <label for="quantity" class="label-quantity"><?=Yii::t('gmv', 'Quantity')?></label>
                    <input type="hidden" id="quantity" name="OrderItem[quantity]" value="1">
                    <div class="touchspin">
                        <?= TouchSpin::widget([
                            'name' => 'OrderItem[quantity]',
                            'id' => 'quantity-touchspin',
                            'pluginOptions' => [
                                'buttonup_class' => 'btn btn-primary', 
                                'buttondown_class' => 'btn btn-primary', 
                                'buttonup_txt' => '<i class="fa fa-plus-circle"></i>', 
                                'buttondown_txt' => '<i class="fa fa-minus-circle"></i>',
                                'step' => 1,
                                'initval' => 1,
                                'min' => 1,
                            ]
                        ]);?>
                    </div>
                </div>                
            </div>
            <div class="row">
                <div class="col-sm-12">
                    <label for="note" class="label-note"><?=Yii::t('gmv', 'Note')?></label>
                    <textarea style="resize: none;" class="form-control" id="note" name="OrderItem[note]" rows="2"></textarea>
                </div>
            </div>
            <br>
            <div class='row'>
                <div class='col-md-12'>
                    <span class='label label-success'><?=Yii::t('gmv','Disponibile')?></span>
                </div>
            </div><br>
            <div class='row'>
                <div class='col-md-12'>
                    <?=Html::button(Yii::t('gmv', 'Add to order'), ['class' => 'btn btn-default btn-block', 'id' => 'add-product-assembled-action-modal']);?>
                </div>
            </div>
        </div>
    </div>
    <?php ActiveForm::end();?>
<?php Modal::end(); ?>
