<?php

namespace bitcream\gmvricambi\custom\common\models;

use Yii;
use bitcream\gmvricambi\custom\common\models\CustomerUser;
/**
 * This is the model class for table "{{%GMV_articles_category}}".
 *
 */
class GMVArticlesCategory extends base\GMVArticlesCategory
{
    /**
     * @inheritdoc $primaryKey
     */
    public static function primaryKey()
    {
        return ["id"];
    }

    public static function getCategoriesChilds($parent_id){
        $parentGMVArticleCategory = GMVArticlesCategory::findone($parent_id);
        $categories['all']  = Yii::t('gmv', 'All');
        $gmvArticlesCategories = $parentGMVArticleCategory->getChilds();
        foreach($gmvArticlesCategories as $gmvArticlesCategory){           
            $categories[$gmvArticlesCategory->id] = $gmvArticlesCategory->name; 
        }
        return $categories;
    }

    public function getChilds(){
        $categoryChilds = GMVArticlesCategory::findAll(['category_parent_id' => $this->id]);
        return $categoryChilds;
    }

    public static function getCategoryName($categoryId){        
        $category = GMVArticlesCategory::findOne(['id' => $categoryId]);
        return $category->name;
    }

    public static function addBreadcrumbLink(){
        $customer = CustomerUser::findOne(Yii::$app->user->id);
        $categorySelected = $customer->getCategorySelected();
        
        while($categorySelected != 0){
            $category = GMVArticlesCategory::findOne(['id' => $categorySelected]);
            $breadcrumbCategory[] = ['label' => Yii::t('gmv', GMVArticlesCategory::getCategoryName($category->id)), 'url' => ['set-category','category'=>$category->id]];
            $categorySelected = $category->category_parent_id;
        }
        
        return array_reverse($breadcrumbCategory);
    }

    public static function getSubcomponentCategory($category){    
        $category = GMVArticlesCategory::findOne(['id' => $category]);
        return $category->subcomponent_cod;
    }

}
