<?php

namespace bitcream\gmvricambi\custom\common\models;

use Yii;
/**
 * This is the model class for table "{{%GMV_customer}}".
 *
 */
class GMVCustomer extends base\GMVCustomer
{
    /**
     * @inheritdoc $primaryKey
     */
    public static function primaryKey()
    {
        return ["customer_cod"];
    }

    /**
     * Funzione che restituisce i metodi di pagamento
     */
    public function getPaymentMethods($total_order){
        $paymentMethodLists = [$this->getBankTransferByLanguage(), $this->getCreditCardCodeByLanguage()];
        if($total_order > Yii::$app->params['minimum_threshold']){
            array_push($paymentMethodLists, $this->payment_term_cod);
        }
        return GMVPaymentMethod::findAll(['payment_cod' => $paymentMethodLists]);
    }

    /**
     * Funzione che restituisce i metodi di pagamento
     */
    public function getBankTransferByLanguage(){
        $nationCod = $this->getCustomerUserLanguage();
        switch ($nationCod) {
            case 'I':
                return Yii::$app->params['bankTransferCode']['I'];
                break;
            case 'GB':
                return Yii::$app->params['bankTransferCode']['GB'];
                break;
            case 'D':
                return Yii::$app->params['bankTransferCode']['D'];
                break;
            case 'F':
                return Yii::$app->params['bankTransferCode']['F'];
                break;
            case 'P':
                return Yii::$app->params['bankTransferCode']['P'];
                break;
            case 'E':
                return Yii::$app->params['bankTransferCode']['E'];
                break;
            default:
                return "";
                break;
        }
    }

    /**
     * Funzione che restituisce i metodi di pagamento
     */
    public function getCreditCardCodeByLanguage(){
        $nationCod = $this->getCustomerUserLanguage();
        switch ($nationCod) {
            case 'I':
                return Yii::$app->params['creditCardCode']['I'];
                break;
            case 'GB':
                return Yii::$app->params['creditCardCode']['GB'];
                break;
            case 'D':
                return Yii::$app->params['creditCardCode']['D'];
                break;
            case 'F':
                return Yii::$app->params['creditCardCode']['F'];
                break;
            case 'P':
                return Yii::$app->params['creditCardCode']['P'];
                break;
            case 'E':
                return Yii::$app->params['creditCardCode']['E'];
                break;
            default:
                return "";
                break;
        }
    }

    public function checkPaymentMethod($paymentMethodCod, $total_order){
        foreach($this->getPaymentMethods($total_order) as $paymentMethod){
            if($paymentMethod->payment_cod == $paymentMethodCod || $paymentMethodCod == 'S'){
                return true;
            }
        }
        return false;
    }

    public function checkRating(){
        if(isset($this->rating_cod) && $this->rating_cod != "D"){
            return true;
        }
        return false;
    }

    public static function getLanguage(){
        $customerUser = CustomerUser::findOne(Yii::$app->user->id);
        if(isset($customerUser->customer->nation_cod)){
            $nationCod = trim($customerUser->customer->nation_cod);
            foreach (Yii::$app->params['language'] as $key => $value){
                if($key == $nationCod){
                    return $value;
                }
            }
        }
        return "it";
    }

    public static function getLanguageBackend(){
        if(Yii::$app->user->id){
            $customerUser = CustomerUser::findOne(Yii::$app->user->id);
            if(isset($customerUser->customer->nation_cod)){
                $nationCod = trim($customerUser->customer->nation_cod);
                foreach (Yii::$app->params['language-backend'] as $key => $value){
                    if($key == $nationCod){
                        return $value;
                    }
                }
            }
        }
        return "it-IT";
    }

    public function getCustomerUserLanguage(){
        if(Yii::$app->user->id){
            $customerUser = CustomerUser::findOne(Yii::$app->user->id);
            if(isset($customerUser->customer->nation_cod)){
                $nationCod = trim($customerUser->customer->nation_cod);
                return $nationCod;
            }
        }
        return;
    }

    public static function setCurrentUserLanguage($event){
        $language = GMVCustomer::getLanguageBackend();
        if($language){
            Yii::$app->language = $language;
            // Yii::$app->sourceLanguage = $language;
        }
    }

    public function getPriceListCod(){
        if(isset($this->price_list_cod)&& !empty($this->price_list_cod)){
            return $this->price_list_cod;
        }
        return "0";
    }

    /**
     * Sends an email with a link, for resetting the password.
     *
     * @return bool whether the email was send
     */
    public function sendEmail($postData)
    {
        $htmlBody = "Name: ".$postData['GMVCustomer']['name']."<br>".
                    "Email: ".$postData['email']."<br>".
                    "Phone: ".$postData['phone']."<br><br>".
                    "Request: ".$postData['request'];


        return Yii::$app->mailer->compose()
            ->setTo(Yii::$app->params['supportEmail'])
            ->setFrom([$postData['email'] => $postData['GMVCustomer']['name']])
            ->setReplyTo(Yii::$app->params['supportEmail'])
            ->setCc(Yii::$app->params['emailCC'])
            ->setSubject($postData['type_request'])
            ->setTextBody($htmlBody)
            ->send();
    }

    /**
     * Gets query for [[ShippingCost]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getGmvShippingCost()
    {
        return $this->hasOne(GMVShippingCost::className(), ['business_zone_cod' => 'zone_cod']);
    }
    /**
     * Gets query for [[ShippingZone]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getGmvShippingZone()
    {
        return $this->hasOne(GMVShippingZone::className(), [ 'country_cod' => 'nation_cod']);
    }

}
