<?php

namespace bitcream\gmvricambi\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%GMV_article}}".
 *
 * @property string $article_cod
 * @property string $description
 * @property string|null $family
 * @property string|null $unit_of_measure_cod
 * @property string|null $unit_of_measure
 * @property float|null $weight
 * @property string|null $packaging_code
 * @property string|null $assembled_product
 *
 * @property Product[] $products
 */
class GMVAssembledArticle extends \yii\db\ActiveRecord
{
    public static function getDb()
    {
        return \Yii::$app->gmv;  
    }
    
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%GMV_article}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['article_cod', 'description'], 'required'],
            [['weight'], 'number'],
            [['article_cod', 'packaging_code'], 'string', 'max' => 15],
            [['description'], 'string', 'max' => 35],
            [['family'], 'string', 'max' => 3],
            [['unit_of_measure_cod'], 'string', 'max' => 2],
            [['unit_of_measure'], 'string', 'max' => 50],
            [['assembled_product'], 'string', 'max' => 1],
            [['article_cod'], 'unique'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'article_cod' => Yii::t('gmv', 'Article Cod'),
            'description' => Yii::t('gmv', 'Description'),
            'family' => Yii::t('gmv', 'Family'),
            'unit_of_measure_cod' => Yii::t('gmv', 'Unit Of Measure Cod'),
            'unit_of_measure' => Yii::t('gmv', 'Unit Of Measure'),
            'weight' => Yii::t('gmv', 'Weight'),
            'packaging_code' => Yii::t('gmv', 'Packaging Code'),
            'assembled_product' => Yii::t('gmv', 'Assembled Product'),
        ];
    }

    /**
     * Gets query for [[Products]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getProducts()
    {
        return $this->hasMany(Product::className(), ['article_cod' => 'article_cod'])->inverseOf('articleCod');
    }
}
