<?php

namespace bitcream\gmvricambi\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%product_component}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%GMV_Article}}`
 */
class M211008114727AddArticleCodColumnToProductComponentTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%product_component}}', 'article_cod', $this->string(15)->notNull());

        // creates index for column `article_cod`
        $this->createIndex(
            '{{%idx-product_component-article_cod}}',
            '{{%product_component}}',
            'article_cod'
        );

        // add foreign key for table `{{%GMV_Article}}`
        $this->addForeignKey(
            '{{%fk-product_component-article_cod}}',
            '{{%product_component}}',
            'article_cod',
            '{{%GMV_Article}}',
            'article_cod',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%GMV_Article}}`
        $this->dropForeignKey(
            '{{%fk-product_component-article_cod}}',
            '{{%product_component}}'
        );

        // drops index for column `article_cod`
        $this->dropIndex(
            '{{%idx-product_component-article_cod}}',
            '{{%product_component}}'
        );

        $this->dropColumn('{{%product_component}}', 'article_cod');
    }
}
