<?php

namespace bitcream\gmvricambi\custom\backend\controllers;

use Yii;
use bitcream\gmvricambi\custom\backend\models\GMVArticleFamilyDiscount;
use bitcream\gmvricambi\custom\backend\models\GMVArticleFamilyDiscountSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
/**
 * GMVArticleFamilyDiscountController implements the CRUD actions for GMVArticleFamilyDiscount model.
 */
class GmvArticleFamilyDiscountController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['login', 'error'],
                        'allow' => true,
                    ],
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all GMVArticleFamilyDiscountController models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new GMVArticleFamilyDiscountSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single GMVArticleFamilyDiscountController model.
     * @param string $customer_cod
     * @param string $family
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($customer_cod, $family)
    {
        return $this->render('view', [
            'model' => $this->findModel($customer_cod, $family),
        ]);
    }

    /**
     * Creates a new GMVArticleFamilyDiscount model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new GMVArticleFamilyDiscount();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'customer_cod' => $model->customer_cod, 'family' => $model->family]);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing GMVArticleFamilyDiscount model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param string $customer_cod
     * @param string $family
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($customer_cod, $family)
    {
        $model = $this->findModel($customer_cod, $family);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'customer_cod' => $model->customer_cod, 'family' => $model->family]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing GMVArticleFamilyDiscount model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param string $customer_cod
     * @param string $family
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($customer_cod, $family)
    {
        $this->findModel($customer_cod, $family)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the GMVArticleFamilyDiscount model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param string $customer_cod
     * @param string $family
     * @return GMVArticleFamilyDiscount the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($customer_cod, $family)
    {
        if (($model = GMVArticleFamilyDiscount::findOne(['customer_cod' => $customer_cod, 'family' => $family])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('gmv', 'The requested page does not exist.'));
    }
}
