<?php

namespace bitcream\gmvricambi\custom\backend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use bitcream\gmvricambi\custom\backend\models\GMVAssembliesPartsArticles;

/**
 * GMVAssembliesPartsArticlesSearch represents the model behind the search form of `bitcream\gmvricambi\custom\backend\models\GMVAssembliesPartsArticles`.
 */
class GMVAssembliesPartsArticlesSearch extends GMVAssembliesPartsArticles
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['IDAssembly', 'IDPart'], 'integer'],
            [['Article_cod', 'Notes'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = GMVAssembliesPartsArticles::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);
        
        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        $query->andFilterWhere(
            ['=', 'IDPart', $params['part_id']]
        );
        $query->andFilterWhere(
            ['=', 'IDAssembly', $params['assembly_id']]
        );

        // grid filtering conditions
        $query->andFilterWhere([
            'IDAssembly' => $this->IDAssembly,
            'IDPart' => $this->IDPart,
        ]);

        $query->andFilterWhere(['like', 'Article_cod', $this->Article_cod])
            ->andFilterWhere(['like', 'Notes', $this->Notes]);

        return $dataProvider;
    }
}
