<?php

namespace bitcream\gmvricambi\custom\common\models;

use Yii;
/**
 * This is the model class for table "{{%GMVAssemblies}}".
 *
 */
class GMVAssemblies extends base\GMVAssemblies
{
    /**
     * @inheritdoc$primaryKey
     */
    public static function primaryKey()
    {
        return ["AssemblyID"];
    }

    /**
     * Gets query for [[OrderItems]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getGmvAssembliesParts()
    {
        return $this->hasMany(GMVAssembliesParts::className(), ['Assembly_ID' => 'AssemblyID']);
    }

    /**
     * Gets query for [[ProductAssemblies]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getProductAssemblies()
    {
        return $this->hasMany(ProductAssemblies::className(), ['assembly_id' => 'AssemblyID']);
    }

     /**
     * Gets query for [[ProductAssembliesImage]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getProductAssembliesImage()
    {
        return $this->hasOne(ProductAssembliesImage::className(), ['AssemblyID' => 'assembly_id']);
    }

    public function getImage(){
        return ProductAssembliesImage::find()->where(['assembly_id' => $this->AssemblyID])->one();
    }
}
