<?php
namespace bitcream\gmvricambi\custom\common\widget;

use Yii;
use yii\base\Widget;
use yii\helpers\Html;
use kartik\select2\Select2;
use bitcream\gmvricambi\custom\common\models\GMVArticlesCategory;
use bitcream\gmvricambi\custom\common\models\CustomerUser;

class CategoryWidget extends Widget
{
    public $categorySelected;
    public $status;

    public function init()
    {
        parent::init();
        AssetWidget::register($this->getView());
    }

    public function run()
    { 
        $customer = CustomerUser::findOne(Yii::$app->user->id);
        $this->categorySelected = $customer->getCategorySelected();
        return $this->render('select-category', [
            'categorySelected' => $this->categorySelected,
            'status' => $this->status,
            'categoryChilds' => GMVArticlesCategory::getCategoriesChilds($this->categorySelected),
        ]);
    }
}
?>
