<?php
namespace bitcream\gmvricambi\custom\common\widget;

use yii\widgets\InputWidget;
use yii\helpers\Html;
use Yii;

class LanguageHiddenWidget extends InputWidget
{
    public $language;
    public $languages;

    public function init()
    {
        parent::init();
        $this->language = $this->currentLanguage();
        AssetWidget::register($this->getView());
    }

    public function run()
    {
        return "<input type='hidden' id='checkbox-".$this->language."' value='".$this->language."' name='language_check[]'>";
    }

    private function currentLanguage(){
        if(!Yii::$app->request->get('lang_create')){
            return 'en';
        }
        return Yii::$app->request->get('lang_create');
    }
}
