<?php

namespace bitcream\gmvricambi\custom\backend\controllers;

use Yii;
use bitcream\gmvricambi\custom\common\models\CustomerUser;
use bitcream\gmvricambi\custom\backend\models\CustomerUserSearch;
use bitcream\gmvricambi\custom\common\models\GMVCustomer;
use bitcream\gmvricambi\custom\common\models\GMVCountry;
use bitcream\gmvricambi\custom\common\models\GMVProvince;
use emberware\evidia\users\common\models\User;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
/**
 * CustomerUserController implements the CRUD actions for CustomerUser model.
 */
class CustomerUserController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['login', 'error', 'sign-in'],
                        'allow' => true,
                    ],
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all CustomerUser models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new CustomerUserSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single CustomerUser model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new CustomerUser model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new CustomerUser();        
        $model->username = "Customer-".rand(1000,9999);
        $model->password_hash = Yii::$app->security->generateRandomString();       

        if ($model->load(Yii::$app->request->post())) {
            $customerUser = $model->createUser(Yii::$app->request->post()['CustomerUser']);            
            return $this->redirect(['view', 'id' => $customerUser->id]);
        }

        return $this->render('create', [
            'model' => $model,
            'customers' => GMVCustomer::find()->orderBy(['name'=>SORT_ASC])->all(),
        ]);
    }

    /**
     * Updates an existing CustomerUser model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
        $password_hash = $model->password_hash;
        if ($model->load(Yii::$app->request->post())) {
            if(!empty(Yii::$app->request->post()["CustomerUser"]["password_hash"])){
                $model->password_hash = Yii::$app->security->generatePasswordHash(Yii::$app->request->post()["CustomerUser"]["password_hash"]);
            }
            else{
                $model->password_hash = $password_hash;
            }
            $model->save();
            return $this->redirect(['view', 'id' => $model->id]);
        }
        $model->password_hash = "";

        return $this->render('update', [
            'model' => $model,
            'customers' => GMVCustomer::find()->orderBy(['name'=>SORT_ASC])->all(),
        ]);
    }

    /**
     * Deletes an existing CustomerUser model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the CustomerUser model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return CustomerUser the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = CustomerUser::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }

    public function actionSignIn(){
        $countries = GMVCountry::find(['description'])->all();
        $provinces = GMVProvince::find()->select(['description'])->all();

        return $this->render('signin', [
            'countries' => $countries,
            'provinces' => $provinces,
        ]);
    }

    public function actionSendRequestNewUser(){
        $body = "";
        if(Yii::$app->request->post()){
            $body = "<h3>Richiesta registrazione nuovo utente</h3>";
            $body .= "<h4>Dati aziendali</h4>";
            $body .= "<b>Nome azienda:</b> ".Yii::$app->request->post()['business_name']."<br>";
            $body .= "<b>Partita iva:</b> ".Yii::$app->request->post()['vat_number']."<br>";
            $body .= "<b>Email:</b> ".Yii::$app->request->post()['email']."<br>";
            $body .= "<b>Pec:</b> ".Yii::$app->request->post()['pec']."<br>";
            $body .= "<b>Codice destinatario SDI:</b> ".Yii::$app->request->post()['sdi_recipient_code']."<br>";
            $body .= "<hr>";
            $body .= "<h4>Indirizzo azienda</h4>";
            $body .= "<b>Indirizzo:</b> ".Yii::$app->request->post()['address']."<br>";
            $body .= "<b>Provincia:</b> ".Yii::$app->request->post()['province']."<br>";
            $body .= "<b>CAP:</b> ".Yii::$app->request->post()['postal_code']."<br>";
            $body .= "<b>Nazione:</b> ".Yii::$app->request->post()['country']."<br>";
            $body .= "<hr>";
            $body .= "<h4>Indirizzo spedizione</h4>";
            $body .= "<b>Indirizzo:</b> ".Yii::$app->request->post()['address_shipping']."<br>";
            $body .= "<b>Provincia:</b> ".Yii::$app->request->post()['province_shipping']."<br>";
            $body .= "<b>CAP:</b> ".Yii::$app->request->post()['postal_code_shipping']."<br>";
            $body .= "<b>Nazione:</b> ".Yii::$app->request->post()['country_shipping']."<br>";

            $resultMail = Yii::$app->mailer->compose()
                                ->setTo(Yii::$app->params['supportEmail'])
                                ->setSubject('Richiesta registrazione nuovo utente')
                                ->setTextBody('Plain text content')
                                ->setHtmlBody($body)
                                ->send();

            return $this->redirect(['request-sent', 'message' => $resultMail]);
        }
    }

    public function actionRequestSent($message){
        return $this->render('request-sent', [
            'message' => $message,
        ]);
    }
}
