<?php

use yii\widgets\Breadcrumbs;
use yii\helpers\Html;
use emberware\evidia\datatable\common\models\DataTableCustom;
use Emberware\Evidia\Field\FlagIcon\FlagIcon;
use bitcream\gmvricambi\custom\backend\models\ProductImage;

?>
<div class="datatable">
        <?=
        DataTableCustom::widget([
            'dataProvider' => $dataProvider,
            'id' => 'category-table',
            'filterModel' => $searchModel,
            //'searchModel' => $searchModel,
            'columns' => [
                'Assembly_ID',
                'Assembly_Part',        
                ['attribute'=>Yii::t('gmv', 'Name'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return Html::a($data->PartName, [Yii::$app->controller->id.'/view','id'=> $data->Assembly_ID, 'Assembly_Label'=> $data->Assembly_Label]);}
                ],                
                'Assembly_Label',
                'PosX',
                'PosY',
            ],
            'clientOptions' => [
                "responsive"=>true,
                "language" => [
                    "url" => Yii::t('gmv',"//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json")
                ]
            ]
        ]);
    ?>
</div>