<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
// use kartik\datecontrol\DateControl;
use yii\helpers\ArrayHelper;
use kartik\select2\Select2;
// use kartik\date\DatePicker;
use bitcream\gmvricambi\custom\common\widget\AddPlantCodeWidget;
/* @var $this yii\web\View */
/* @var $model bitcream\gmvricambi\custom\backend\models\Order */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="order-form">

    <?php $form = ActiveForm::begin(); ?>

    <div class="row">
        <div class="col-md-6">
            <?= $form->field($model, 'name')->textInput(['maxlength' => true]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6">
            <?= $form->field($model, 'order_reference')->textInput(['maxlength' => true]) ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6">
            <?= AddPlantCodeWidget::widget(['multiple' => true, 'search' => false, 'model' => $model]); ?><br>
        </div>
    </div>
    <div class='row'>
        <div class='col-md-6 col-xs-12'>
            <label class="control-label"><?=Yii::t('gmv','Delivery methods')?></label>
            <?= Select2::widget([
                'name' => 'Order[shipping_term]',
                'id' => 'shipping_term',
                'data' => [
                    '02' => Yii::t('gmv',"Ritiro cliente c/o GMV Stabilimento di Novara (porto assegnato)"),
                    '01' => Yii::t('gmv',"Spedizione a mezzo corriere direttamente presso indirizzo fornito dal cliente (porto franco/DAP)")
                ],
                'value' => $model->shipping_term,
                'options' => [
                    'placeholder' => Yii::t('gmv','Select a delivery methods ...'),
                ],
            ]);?>
        </div>
    </div>
    <div class="row order_courier_subscription_code">
        <div class="col-md-6">
            <?= $form->field($model, 'courier_subscription_code')->textInput(['maxlength' => true]) ?>
        </div>
    </div>

    <?= $this->render('_form_address', [
        'model' => $model,
        'form' => $form,
        'order' => $order,
        'countries' => $countries,
        'provinces' => $provinces,
        'shippingAddress' => $shippingAddress,
    ]) ?>

    <div class='row shipping_method_row'>
        <div class='col-md-6 col-xs-12'>
            <br>
            <label class="control-label"><?=Yii::t('app','Shipping methods')?></label>            
            <?=  Select2::widget([
                'name' => 'Order[shipping_method]',
                'id' => 'shipping_method',
                'data' => [
                    'G' =>  Yii::t('gmv','Ground shipping'),
                    'A' =>  Yii::t('gmv','Shipping by air')
                ],
                'value' => $model->shipping_method,
                'options' => [
                    'placeholder' => Yii::t('gmv','Select shipping method'),
                    'multiple' => false
                ],
            ]);               
            ?>
        </div>
    </div><br>

    <div class="form-group">
        <?= Html::submitButton(Yii::t('gmv', 'Save'), ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
