<?php 
use kartik\select2\Select2;
use yii\helpers\ArrayHelper;
use yii\helpers\Html;
?>

<div class="row">
    <div class="col-sm-12">
        <b class="shipping_cost_label_b"><?=Yii::t('gmv','Shipping cost')?></b>
        <input type="hidden" id="shipping_method" name="shipping_method"  value="<?=$model->shipping_term?>">
        <input type="hidden" id="shipping_cost_calc" name="shipping_cost_calc" class='shipping_cost_calc form-control' value="<?=$model->getShippingCost()?>">
        <input type="hidden" id="nation_cod" name="nation_cod" value="<?=$model->nationCod?>">
        <p class="shipping_cost_label">€ <?=$model->getShippingCost()?></p>
    </div>
</div>

<div class="row">
    <div class="col-sm-12">
        <input type="hidden" id="total" name="total" value="<?=$model->total?>">
        <h3><?=Yii::t('gmv','Total: € ')?><span class="total_update"><?=$model->total?></span></h3>
        
            <b><?=Yii::t('gmv','Select Payment Method')?></b><br>
            <?=  Select2::widget([
                'name' => 'payment_method',
                'data' => ArrayHelper::map($paymentMethods,'payment_cod','description'),
                'options' => [
                    'placeholder' => Yii::t('gmv','Select payment method'),
                    'multiple' => false
                ],
            ]);               
            ?>
    </div>
</div>

<br>
<div class="row">
    <div class="col-sm-12">
        <input type="checkbox" id="shipping_terms" name="shipping_terms" class='shipping_terms'>
        <label for="shipping_terms"><?=Yii::t('gmv',' To continue accept the shipping terms.')?></label><br>
        <a href="#"><?=Yii::t('gmv','Read the shipping terms.')?></a>
    </div>
</div>
<br>
<div class="right-align">
    <?=Html::submitButton(Yii::t('gmv','Confirm'), ['class' => 'btn btn-success', 'id' => 'confirm', 'disabled' => 'disabled'])?>
</div>