<?php

namespace bitcream\gmvricambi\custom\common\models;

use Yii;
/**
 * This is the model class for table "{{%GMVArticlePriceList}}".
 *
 */
class GMVArticlePriceList extends base\GMVArticlePriceList
{
    public static function currentUserArticlePrices(string $articleCod, int $quantity = 1){
        $customerUser = CustomerUser::getCurrentUser();
        return self::userArticlePrices($customerUser->customer, $articleCod, $quantity);
    }
    public static function userArticlePrices($gmvCustomer, $articleCod, int $quantity = 1){
        $articlePrice = GMVArticlePriceList::find()
            ->where([
                        'price_list_cod' => $gmvCustomer->priceListCod,
                        'article_cod' => $articleCod,
                        'customer_cod' => [$gmvCustomer->customer_cod, '**'],
                    ])
            ->andWhere(['<=', 'quantity', $quantity])
            ->orderBy([
                'customer_cod' => SORT_DESC,
                'quantity' => SORT_DESC,
                ])
            ->one();

        // foreach($articlePrices as $articlePrice){
        //     $selectedArticlePrice = $articlePrice;
        // }
        return $articlePrice;
    }

    public static function currentUserArticlesCod(){
        $customerUser = CustomerUser::getCurrentUser();
        return self::userArticlesCod($customerUser->customer);
    }
    public static function userArticlesCod($gmvCustomer){
        $articleList = array();
        $articles = GMVArticlePriceList::find()
            ->select('article_cod')
            ->where([
                        'price_list_cod' => $gmvCustomer->priceListCod,
                        'customer_cod' => [$gmvCustomer->customer_cod, '**']
                    ])
            ->distinct()
            ->all();

        foreach($articles as $article){
            array_push($articleList, $article);
        }

        return $articleList;
    }

    public static function filterCurrentUserArticle(&$query){
        $customerUser = CustomerUser::getCurrentUser();
        self::filterUserArticle($query, $customerUser->customer);
    }

    public static function filterUserArticle(&$query, $gmvCustomer){
        $query->innerJoin('GMV_article_price_list', 'GMV_article_price_list.article_cod = GMV_article.article_cod');
        $query->andWhere(
            [
                'price_list_cod' => $gmvCustomer->priceListCod,
                'customer_cod' => [$gmvCustomer->customer_cod, '**']
            ]
        );
    }

}
