<?php

namespace bitcream\gmvricambi\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%GMV_assemblies_parts}}".
 *
 * @property int $Assembly_ID
 * @property int $Assembly_Part
 * @property string $Assembly_Label
 * @property string $PartName
 * @property int $PosX
 * @property int $PosY
 */
class GMVAssembliesParts extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%GMV_assemblies_parts}}';
    }

    /**
     * @return \yii\db\Connection the database connection used by this AR class.
     */
    public static function getDb()
    {
        return Yii::$app->get('gmv');
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['Assembly_ID', 'Assembly_Part', 'Assembly_Label', 'PartName', 'PosX', 'PosY'], 'required'],
            [['Assembly_ID', 'Assembly_Part', 'PosX', 'PosY'], 'integer'],
            [['Assembly_Label', 'PartName'], 'string', 'max' => 255],
            [['Assembly_ID', 'Assembly_Part', 'Assembly_Label'], 'unique', 'targetAttribute' => ['Assembly_ID', 'Assembly_Part', 'Assembly_Label']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'Assembly_ID' => Yii::t('gmv', 'Assembly ID'),
            'Assembly_Part' => Yii::t('gmv', 'Assembly Part'),
            'Assembly_Label' => Yii::t('gmv', 'Assembly Label'),
            'PartName' => Yii::t('gmv', 'Part Name'),
            'PosX' => Yii::t('gmv', 'Pos X'),
            'PosY' => Yii::t('gmv', 'Pos Y'),
        ];
    }
}
