<?php

namespace bitcream\gmvricambi\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%language}}".
 *
 * @property int $id
 * @property string|null $class
 * @property string|null $label
 * @property int|null $object_id
 * @property string|null $value
 * @property int|null $status
 * @property string|null $created_at
 * @property int|null $created_user_id
 * @property string|null $updated_at
 * @property int|null $updated_user_id
 */
class Language extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%language}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['object_id', 'status', 'created_user_id', 'updated_user_id'], 'integer'],
            [['class', 'label', 'value', 'created_at', 'updated_at'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('gmv', 'ID'),
            'class' => Yii::t('gmv', 'Class'),
            'label' => Yii::t('gmv', 'Label'),
            'object_id' => Yii::t('gmv', 'Object ID'),
            'value' => Yii::t('gmv', 'Value'),
            'status' => Yii::t('gmv', 'Status'),
            'created_at' => Yii::t('gmv', 'Created At'),
            'created_user_id' => Yii::t('gmv', 'Created User ID'),
            'updated_at' => Yii::t('gmv', 'Updated At'),
            'updated_user_id' => Yii::t('gmv', 'Updated User ID'),
        ];
    }
}
