<?php

namespace bitcream\gmvricambi\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%order_item}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%order}}`
 */
class M210820124624AddOrderIdColumnToOrderItemTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%order_item}}', 'order_id', $this->integer()->null());

        // creates index for column `order_id`
        $this->createIndex(
            '{{%idx-order_item-order_id}}',
            '{{%order_item}}',
            'order_id'
        );

        // add foreign key for table `{{%order}}`
        $this->addForeignKey(
            '{{%fk-order_item-order_id}}',
            '{{%order_item}}',
            'order_id',
            '{{%order}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%order}}`
        $this->dropForeignKey(
            '{{%fk-order_item-order_id}}',
            '{{%order_item}}'
        );

        // drops index for column `order_id`
        $this->dropIndex(
            '{{%idx-order_item-order_id}}',
            '{{%order_item}}'
        );

        $this->dropColumn('{{%order_item}}', 'order_id');
    }
}
