<?php

use yii\widgets\Breadcrumbs;
use yii\helpers\Html;
use emberware\evidia\datatable\common\models\DataTableCustom;
use Emberware\Evidia\Field\FlagIcon\FlagIcon;
use bitcream\gmvricambi\custom\backend\models\ProductAssembliesImage;

?>
<div class="datatable">
        <?=
        DataTableCustom::widget([
            'dataProvider' => $dataProvider,
            'id' => 'category-table',
            'filterModel' => $searchModel,
            //'searchModel' => $searchModel,
            'columns' => [
                ['attribute'=>Yii::t('gmv', 'Image'),
                    'format'=>'raw',
                    'value' => function($data)
                    { return (isset($data->image->image))? Html::img($data->image->image, ['class' => 'img-thumbnail'])  : ""; }
                ], 
                ['attribute'=>Yii::t('gmv', 'Name'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return Html::a($data->AssemblyName, [Yii::$app->controller->id.'/view','id'=> $data->AssemblyID]);}
                ],  
                [
                    'format'=>'raw',
                    'label' => 'Azioni',
                    'value' => function ($model, $key, $index, $column) use ($languages)
                    {
                        $arrLang = array();
                        //Get product with article_cod
                        $htmlButtons = "";
                        // $model->products;
                        $productImageAssemblies = ProductAssembliesImage::find()->where(['assembly_id' => $model->AssemblyID])->one();
                        if(!isset($productImageAssemblies->assembly_id)){
                            $htmlButtons .= " ".Html::a(Yii::t('gmv', '<i class="fa fa-plus"></i> <i class="fa fa-picture-o"></i>'), ['product-assemblies-image/create', 'assembly_id' => $model->AssemblyID, 'controller'=>Yii::$app->controller->id], ['class' => 'btn btn-primary action-button']);
                        }else{
                            // $htmlButtons .= " ".Html::a(Yii::t('gmv', '<i class="fa fa-pencil"></i> <i class="fa fa-picture-o"></i>'), ['product-assemblies-image/update', 'assembly_id' => $model->AssemblyID, 'id'=> $productImageAssemblies->id, 'controller'=>Yii::$app->controller->id], ['class' => 'btn btn-primary action-button']);
                            $htmlButtons .= " ".Html::a(Yii::t('gmv', '<i class="fa fa-trash-o"></i> <i class="fa fa-picture-o"></i>'), ['product-assemblies-image/delete', 'id'=> $productImageAssemblies->id, 'controller'=>Yii::$app->controller->id], [
                                'class' => 'btn btn-danger action-button',
                                'data' => [
                                    'confirm' => Yii::t('gmv','Are you sure you want to delete this product image assemblies?'),
                                    'method' => 'post',
                                ]
                            ]);
                        }

                        if($model->productAssemblies){
                            foreach($model->productAssemblies as $productAssembly){
                                $lang = $productAssembly->getLanguageObject();
                                if($lang){
                                    if($lang->label == "en"){
                                        $country = "gb";
                                    }else{
                                        $country = $lang->label;
                                    }
                                    $flag = FlagIcon::widget([
                                        'countryCode' => $country,
                                        'options' => [
                                            'class' => 'flag-button'
                                        ]                            
                                    ]);

                                    array_push($arrLang, $lang->label);
                                    
                                    $htmlButtons .= " ".Html::a(Yii::t('gmv', '{flag} &nbsp;<i class="fa fa-pencil"></i>', ['flag' => $flag]), ['product-assemblies/update', 'id' => $productAssembly->id, 'assembly_id' => $model->AssemblyID], ['class' => 'btn btn-warning action-button']);
                                    $htmlButtons .= " ".Html::a(Yii::t('gmv', '{flag} &nbsp;<i class="fa fa-trash-o"></i>', ['flag' => $flag]), ['product-assemblies/delete', 'id'=> $productAssembly->id, 'controller'=>Yii::$app->controller->id], 
                                        [
                                            'class' => 'btn btn-danger action-button',
                                            'data' => [
                                                'confirm' => Yii::t('gmv','Are you sure you want to delete this product assemblies?'),
                                                'method' => 'post',
                                            ]
                                        ]);
                                }
                            }
                        }

                        foreach($languages as $language) 
                        {
                            if (!in_array($language, $arrLang)) {
                                if($language == "en"){
                                    $country = "gb";
                                }else{
                                    $country = $language;
                                }
                                $flag = FlagIcon::widget([
                                    'countryCode' => $country,
                                    'options' => [
                                        'class' => 'flag-button'
                                    ]                            
                                ]);
                                $htmlButtons .= " ".Html::a(Yii::t('gmv', '{flag} &nbsp;<i class="fa fa-plus"></i>', ['flag' => $flag]), ['product-assemblies/create', 'lang_create' => $language, 'assembly_id' => $model->AssemblyID], ['class' => 'btn btn-success action-button']);
                            }
                        }

                        return $htmlButtons;
                       
                    }
                ],              
            ],
            'clientOptions' => [
                "responsive"=>true,
                "language" => [
                    "url" => Yii::t('gmv',"//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json")
                ]
            ]
        ]);
    ?>
</div>
