<?php

namespace bitcream\gmvricambi\custom\backend\models;

use Yii;
use bitcream\gmvricambi\custom\backend\models\Product;
use bitcream\gmvricambi\custom\common\models\CustomerUser;
/**
 * This is the model class for table "{{%GMV_article}}".
 *
 */
class GMVArticle extends \bitcream\gmvricambi\custom\common\models\GMVArticle
{
  /**
     * Gets query for [[Product]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getProducts()
    {
        return $this->hasMany(Product::className(), ['article_cod' => 'article_cod']);
    }

    /**
     * Gets query for [[Products]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCategory()
    {
        return $this->hasOne(GMVArticlesCategory::className(), ['subcomponent_cod' => 'subcomponent_cod']);
    }


     /**
     * Se c'è traduzione carico Product translation
     * Se non c'è traduzione carico GMV Article
     */
    public function getAttributeTranslation(){        
        $customerUser = CustomerUser::findOne(Yii::$app->user->id);
        $language = $customerUser->customer->language;        
        $products = Product::find()->where(['article_cod' => $this->article_cod, 'status' => '30'])->all();        

        if(empty($products)){
            return  [
                'model' => $this,
                'attributes' => [
                    'article_cod',
                    'description',
                    'unit_of_measure_cod',
                    'unit_of_measure',
                    [
                        'label' => 'weight',
                        'value' => round($this->weight,2),   
                    ],                  
                    'price',
                    'category' => 'category.name',
                ]                
            ];
        }

        $product = Language::getTranslation($language, $products);     
        return [
            'model' => $product,
            'attributes' => [
                'article_cod',
                'name',
                    [
                        'attribute' => 'description',
                        'format' => 'html',
                    ],
                [
                    'attribute' => 'detail',
                    'format' => 'html',
                ],

                'category' => 'category.name',
            ]
        ];
    }

    /**
     * Gets query for [[Product]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getProductTranslation()
    {
        $products = Product::find()->where(['article_cod' => $this->article_cod, 'status' => '30'])->all();
        if(!empty($products)){
            $customerUser = CustomerUser::findOne(Yii::$app->user->id);
        }         
        if(!empty($customerUser)){
            $language = $customerUser->customer->language;
        }
        if(!empty($language)){
            $product = Language::getTranslation($language, $products); 
            return $product->name;
        }
        return $this->description;
    }

    public function getCoverImage(){
        return ProductImage::find()->where(['article_cod' => $this->article_cod])->one();
    }

    public function getWeight(){
        return 2;
    }
}
