<?php

namespace bitcream\gmvricambi\custom\backend\models;

use Yii;
use bitcream\gmvricambi\custom\common\behaviors\StatusBehaviors;
use bitcream\gmvricambi\custom\common\behaviors\CreateUpdateBehaviors;
use yii2tech\ar\softdelete\SoftDeleteBehavior;
use yii\helpers\ArrayHelper;
use bitcream\gmvricambi\custom\common\behaviors\LanguageBehaviors;

/**
 * This is the model class for table "{{%product_component}}".
 *
 */
class ProductComponent extends \bitcream\gmvricambi\custom\common\models\ProductComponent
{
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            'softDeleteBehavior' => [
                'class' => SoftDeleteBehavior::className(),
                'softDeleteAttributeValues' => [
                    'status' => 0
                ],
                'replaceRegularDelete' => true // mutate native `delete()` method
            ],
            'status' => [
                'class' => StatusBehaviors::className(),
            ],
            'create-update' => [
                'class' => CreateUpdateBehaviors::className(),
            ]
        ]);
    }

    public static function getComponents($articleCod){
        return ProductComponent::find()->where(['article_cod' => $articleCod, 'status' => 30])->all();
    }
}
