<?php

namespace bitcream\gmvricambi\custom\common\models;

use Yii;
/**
 * This is the model class for table "{{%GMV_paymentMethod}}".
 *
 */
class GMVPaymentMethod extends base\GMVPaymentMethod
{
    /**
     * @inheritdoc $primaryKey
     */
    public static function primaryKey()
    {
        return ["payment_cod"];
    }

    public static function isInstantPayment($paymentMethodCod){
        if($paymentMethodCod == "A25" || $paymentMethodCod == "A26" || $paymentMethodCod == "A27" || $paymentMethodCod == "A28" || $paymentMethodCod == "A29" || $paymentMethodCod == "A30") {
            return true;
        }
        return false;
    }

    public static function isBankTransferPayment($paymentMethodCod){
        return in_array($paymentMethodCod, ["A40", "A03", "A13", "A41"]);
    }
}
