<?php

namespace bitcream\gmvricambi\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%GMV_agent}}".
 *
 * @property string $customer_cod
 * @property string $agent_cod
 * @property string|null $name
 */
class GMVAgent extends \yii\db\ActiveRecord
{
    public static function getDb()
    {
        // use the "db2" application component
        return \Yii::$app->gmv;  
    }

    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%GMV_agent}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['customer_cod', 'agent_cod'], 'required'],
            [['customer_cod', 'agent_cod'], 'string', 'max' => 16],
            [['name'], 'string', 'max' => 80],
            [['customer_cod', 'agent_cod'], 'unique', 'targetAttribute' => ['customer_cod', 'agent_cod']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'customer_cod' => Yii::t('gmv', 'Customer Cod'),
            'agent_cod' => Yii::t('gmv', 'Agent Cod'),
            'name' => Yii::t('gmv', 'Name'),
        ];
    }
}
