<?php

namespace bitcream\gmvricambi\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%GMV_shipping_zone}}".
 *
 * @property string $country_cod
 * @property int $zone_cod
 */
class GMVShippingZone extends \yii\db\ActiveRecord
{
    public static function getDb()
    {
        return \Yii::$app->gmv;  
    }
    
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%GMV_shipping_zone}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['country_cod', 'zone_cod'], 'required'],
            [['zone_cod'], 'integer'],
            [['country_cod'], 'string', 'max' => 3],
            [['country_cod', 'zone_cod'], 'unique', 'targetAttribute' => ['country_cod', 'zone_cod']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'country_cod' => Yii::t('gmv', 'Country Cod'),
            'zone_cod' => Yii::t('gmv', 'Zone Cod'),
        ];
    }
}
