<?php
namespace bitcream\gmvricambi\custom\common\widget;

use yii\base\Widget;
use yii\helpers\Html;
use Yii;
use bitcream\gmvricambi\custom\common\models\GMVSparePartsForOrder;
use bitcream\gmvricambi\custom\common\models\CustomerUser;
use yii\helpers\ArrayHelper;

class AddPlantCodeWidget extends Widget
{
    public $plantCodes;
    public $search;
    public $multiple;
    public $model;

    public function init()
    {
        parent::init();
        AssetWidget::register($this->getView());
    }

    public function run()
    {
        $this->plantCodes = GMVSparePartsForOrder::getCustomerPlant();        

        return $this->render('add-plant-code', [
            'plantCodes' => $this->plantCodes,
            'multiple' => $this->multiple,
            'value' => $this->getPlantCodeDataSelected(),
            'data' => $this->getPlantCodeData(),
        ]);
    }

    public function getPlantCodeDataSelected(){
        $customerUser = CustomerUser::findOne(Yii::$app->user->id);
        if(isset($customerUser->plantCodeSelected) && ($this->search == true)){
            return $customerUser->plantCodeSelected;
        }

        if($this->multiple){
            return $this->model->plant_reference;
        }
        return "";
    }

    public function getPlantCodeData(){
        $data = ArrayHelper::map($this->plantCodes, 'plant_cod', function ($plantCode) {
            return $plantCode['plant_cod']." - ".$plantCode['plant_reference'].' - '.$plantCode['order_reference'];          
        });

        if($this->multiple && !empty($this->getPlantCodeDataSelected())){
            foreach($this->getPlantCodeDataSelected() as $plantCode){
                if(!array_key_exists($plantCode, $data)){
                    $data[$plantCode] = $plantCode;
                }
            }
        }
        return $data;       
    }
}
