<?php
namespace bitcream\gmvricambi\custom\common\widget;

use yii\base\Widget;
use yii\helpers\Html;
use Yii;
use bitcream\gmvricambi\custom\common\widget\AssetWidget;
use bitcream\gmvricambi\custom\common\models\UserOption;
use Emberware\Evidia\Field\FlagIcon\FlagIcon;

class OrderActionWidget extends Widget
{
    public $model;
    public $status;
    public $activeOrder;
    public $orderActionButtons = array();
    public $categoryMessage;

    public function init()
    {
        parent::init();
        AssetWidget::register($this->getView());
    }

    public function run()
    {
        switch ($this->status){
            case 'processing':
                $this->orderActionButtons =  [
                    [
                        'type' => 'update',
                    ],
                    [
                        'type' => 'delete',
                    ],
                    [
                        'type' => 'confirm',
                        'options' => [
                            'class' => 'btn btn-success popup-modal',
                            'data-toggle' => 'modal',
                            'data-target' => '#modal',
                            'data-id'     => $this->model->id,
                            'data-name'   => $this->model->name,
                            'id'          => 'popupModal',
                        ]
                    ],
                    // [
                    //     'type' => 'duplicate',
                    // ],
                    [
                        'type' => 'print',
                    ],
                ];
                // if(empty($this->activeOrder) || ($this->activeOrder->id != $this->model->id)){
                //     $buttons = [
                //         'type' => 'active',
                //     ];
                //     array_push($this->orderActionButtons, $buttons);
                // }                
                break;
            case 'to_quote':
                    $this->orderActionButtons =  [
                        [
                            'type' => 'print',
                        ],                     
                    ];             
                    break;
            case 'quoted':
                    $this->orderActionButtons =  [
                        [
                            'type' => 'update',
                        ],
                        [
                            'type' => 'delete',
                        ],
                        [
                            'type' => 'confirm',
                            'options' => [
                                'class' => 'btn btn-success popup-modal',
                                'data-toggle' => 'modal',
                                'data-target' => '#modal',
                                'data-id'     => $this->model->id,
                                'data-name'   => $this->model->name,
                                'id'          => 'popupModal',
                            ]
                        ],
                        [
                            'type' => 'print',
                        ],                      
                    ];             
                    break;
            case 'deleted':
                $this->orderActionButtons =  [
                    // [
                    //     'type' => 'duplicate',
                    // ],                   
                ];
                break;
            case 'sent':
                $this->orderActionButtons =  [
                    // [
                    //     'type' => 'duplicate',
                    // ],                   
                ];
            case 'confirmed':
                $this->orderActionButtons =  [
                    // [
                    //     'type' => 'duplicate',
                    // ],                   
                ];
            case 'paid':
                $this->orderActionButtons =  [
                    // [
                    //     'type' => 'duplicate',
                    // ],
                    [
                        'type' => 'print',
                    ],                   
                ];
                break;
        }

        $htmlButtons = "<div class='action-box'>";
        foreach($this->orderActionButtons as $orderActionButton){
            switch ($orderActionButton["type"]) {
                case 'update':
                    $htmlButtons .= Html::a(Yii::t($this->categoryMessage, 'Update'), ['update', 'id' => $this->model->id], ['class' => 'btn btn-primary action-button']);
                    break;
                case 'delete':
                    $htmlButtons .= Html::a(Yii::t($this->categoryMessage, 'Delete'), ['delete', 'id' => $this->model->id], [
                        'class' => 'btn btn-danger action-button',
                        'data' => [
                            'confirm' => 'Are you sure you want to delete this '.Yii::$app->controller->id.'?',
                            'method' => 'post',
                        ],
                    ]);
                    break;
                case 'confirm':
                    if(!empty($this->model->orderItems)){
                        $custom_params = ['class' => 'btn btn-success action-button'];
                        if(array_key_exists('options', $orderActionButton)){
                            $custom_params =array_merge($custom_params ,$orderActionButton['options']);
                        }
                        $htmlButtons .= Html::a(Yii::t($this->categoryMessage, 'Confirm'), ['sent-gmv', 'id' => $this->model->id], $custom_params);
                    }                 
                    
                    break;
                case 'print':
                    $htmlButtons .= Html::button(Yii::t($this->categoryMessage, '<i class="fa fa-print"></i> '.Yii::t('gmv', 'Print')), ['class' => 'btn btn-default action-button', 'onclick' =>'window.print()']);
                    break;
                case 'duplicate':
                    $htmlButtons .= Html::a("<i class='fa fa-files-o'></i> ".Yii::t('gmv','Duplicate order'), ['order-customer/duplicate-order', 'id'=> $this->model->id],                    
                    [
                        'class' => 'btn btn-default action-button',
                        'data' => [
                            'confirm' => Yii::t('gmv','Do you want to duplicate this order?'),
                            'method' => 'post',
                        ]
                    ]); 
                    break;
                // case 'active':
                //     $htmlButtons .= Html::a(Yii::t($this->categoryMessage, 'Active order'), ['activate-order', 'id' => $this->model->id], ['class' => 'btn btn-primary action-button']);
                //     break;
                case 'custom':
                    $custom_params = ['class' => 'btn btn-'.$orderActionButton['warning-level'].' action-button '.$orderActionButton['class']];
                    if(array_key_exists('options', $orderActionButton) && !empty($orderActionButton['options'])){
                        $custom_params =array_merge($custom_params ,$orderActionButton['options']);
                    }
                    $htmlButtons .= Html::a(Yii::t($this->categoryMessage, $orderActionButton['title']), $orderActionButton['url'], $custom_params);
                    break;
                case 'custom-modal':
                    $custom_params = ['class' => 'btn btn-'.$orderActionButton['warning-level'].' action-button '.$orderActionButton['class'], 'id' => $orderActionButton['id']];
                    if(array_key_exists('options', $orderActionButton) && !empty($orderActionButton['options'])){
                        $custom_params = array_merge($custom_params, $orderActionButton['options']);
                    }
                    $htmlButtons .= Html::button(Yii::t($this->categoryMessage, $orderActionButton['title']), $custom_params);
                    break;
                default:
                    # code...
                    break;
            }
        }
        $htmlButtons .= "</div>";
        return $htmlButtons;
    }
}
?>
