<?php

namespace bitcream\gmvricambi\custom\common\models;

use Yii;
use emberware\evidia\useroptions\common\models\UserOption;
use Emberware\Evidia\Model\GotifySender\utils\Gotify;
use emberware\evidia\users\common\models\User;
/**
 * This is the model class for table "{{%user}}".
 * @property GMVCustomer $customer
 * @property Order $activeOrder
 * @property String $customerCod
 * @property String $ordersStatusSelected
 */
class CustomerUser extends \emberware\evidia\users\common\models\User
{

    /**
     * Gets query for [[Customer]].
     *
     * @return GMVCustomer
     */
    public function getCustomer()
    {
        // return $this->hasMany(Store::className(), ['store_manager_id' => 'id'])->inverseOf('storeManager');
        $customer_cod = $this->customerCod;

        return  GMVCustomer::find()->where(['customer_cod' => $customer_cod])->one();
    }

    public function getCustomerCod(){
        return UserOption::getUserOption("customer_cod", $this);
    }

    public function setCustomerCod(String $customerCod){
        UserOption::setUserOptionNewUser("customer_cod", $customerCod, $this);
        return true;
    }
    /**
     * Set for [[Customer]].
     *
     * @return boolean
     */
    public function setCustomer(GMVCustomer $customer)
    {
       $this->setCustomerCod($customer->customer_cod);
        // UserOption::setUserOptionNewUser("customer_cod", , $this);
        return true;
    }

    /**
     * Gets query for [[ActiveOrder]].
     *
     * @return Order
     */
    public function getActiveOrder()
    {
        $active_order = UserOption::getUserOption("active_order_id", $this);

        return  Order::find()->where(['id' => $active_order])->one();    
    }

    /**
     * Set for [[ActiveOrder]].
     *
     * @return bool
     */
    public function setActiveOrder(Order $order)
    {
        $this->unsetActiveOrder($order->id);
        UserOption::setUserOptionNewUser("active_order_id", $order->id, $this);
        return true;
    }

    /**
     * Set for [[closedOrder]].
     *
     * @return bool
     */
    public function setClosedOrder(Order $order)
    {
        $this->unsetActiveOrder($order->id);
        return true;
    }

    /**
     * setOrdersStatusSelected
     */
    public function setOrdersStatusSelected(String $orderStatusSelected)
    {
        $this->unsetOrdersStatusSelected(); 
        UserOption::setUserOptionNewUser("order_status_selected", $orderStatusSelected, $this);
        return true;
    }

     /**
     * Set for [[ActiveOrder]].
     *
     * @return bool
     */
    public function unsetOrdersStatusSelected()
    {
        $orderStatusSelectedOptions = UserOption::find()->where(['user_id' => Yii::$app->user->id, 'field' => 'order_status_selected'])->one();
        if($orderStatusSelectedOptions){
            $orderStatusSelectedOptions->delete();
        }        
        return true;
    }
    
    /**
     * getOrdersStatusSelected
     */
    public function getOrdersStatusSelected()
    {
        return (UserOption::getUserOption("order_status_selected", $this))? UserOption::getUserOption("order_status_selected", $this) : $this->setOrdersStatusSelected('processing');
    }

    /**
     * Set for [[ActiveOrder]].
     *
     * @return bool
     */
    public function unsetActiveOrder($id = NULL)
    {
        $activeOrder = UserOption::find()->where(['user_id' => Yii::$app->user->id, 'field' => 'active_order_id'])->one();
        if($activeOrder){
            $activeOrder->delete();
        }        
        return true;
    }

    public static function getCurrentUser(){

        return CustomerUser::findOne(Yii::$app->user->id);
    }

    public function createUser($userData){
        $model = new User();
        $model->username = $userData['username'];
        $model->name = $userData['name'];
        $model->surname = $userData['surname'];
        $model->email = $userData['email'];
        $model->password_hash = Yii::$app->security->generatePasswordHash($userData['password_hash']);
        $model->auth_key = $model->generateAuthKey();
        $model->created_user_id = Yii::$app->user->id;
        $model->updated_user_id = Yii::$app->user->id;
        $model->created_at = (string)time();
        $model->updated_at = (string)time();
        $model->status = 30;
        $model->date_subscription = (string)time();
        $model->save();

        $customerUser = CustomerUser::findOne($model->id);
        $customerUser->setCustomerCod($userData['customerCod']);

        $auth = \Yii::$app->authManager;
        $customerUserRole = $auth->getRole('customer');
        $auth->assign($customerUserRole, $model->id);

        return $customerUser;
    }

    /**
     * setOrdersStatusSelected
     */
    public function setOrderDestinationSelected(String $destinationSelected)
    {
        $this->unsetOrderDestinationSelected(); 
        UserOption::setUserOptionNewUser("order_destination", $destinationSelected, $this);
        return true;
    }

     /**
     * Set for [[ActiveOrder]].
     *
     * @return bool
     */
    public function unsetOrderDestinationSelected()
    {
        $destinationSelected = UserOption::find()->where(['user_id' => Yii::$app->user->id, 'field' => 'order_destination'])->one();
        if($destinationSelected){
            $destinationSelected->delete();
        }        
        return true;
    }

    /**
     * getDestinationSelected
     */
    public function getDestinationSelected()
    {
        return (UserOption::getUserOption("order_destination", $this))? UserOption::getUserOption("order_destination", $this): "all";
    }

    /**
     * setOrdersStatusSelected
     */
    public function setOrderStartDateSelected(String $startDateSelected)
    {
        $this->unsetOrderStartDateSelected(); 
        UserOption::setUserOptionNewUser("order_start_date", $startDateSelected, $this);
        return true;
    }

     /**
     * Set for [[ActiveOrder]].
     *
     * @return bool
     */
    public function unsetOrderStartDateSelected()
    {
        $startDateSelected = UserOption::find()->where(['user_id' => Yii::$app->user->id, 'field' => 'order_start_date'])->one();
        if($startDateSelected){
            $startDateSelected->delete();
        }        
        return true;
    }

    /**
     * getStartDateSelected
     */
    public function getStartDateSelected()
    {
        return (UserOption::getUserOption("order_start_date", $this))? UserOption::getUserOption("order_start_date", $this) : strtotime("-1 months");
    }

    /**
     * setOrderEndDateSelected
     */
    public function setOrderEndDateSelected(String $endDateSelected)
    {
        $this->unsetOrderEndDateSelected(); 
        UserOption::setUserOptionNewUser("order_end_date", $endDateSelected, $this);
        return true;
    }

     /**
     * Set for [[ActiveOrder]].
     *
     * @return bool
     */
    public function unsetOrderEndDateSelected()
    {
        $endDateSelected = UserOption::find()->where(['user_id' => Yii::$app->user->id, 'field' => 'order_end_date'])->one();
        if($endDateSelected){
            $endDateSelected->delete();
        }        
        return true;
    }

    /**
     * getEndDateSelected
     */
    public function getEndDateSelected()
    {
        return (UserOption::getUserOption("order_end_date", $this))? UserOption::getUserOption("order_end_date", $this): strtotime("today 23:59");
    }

     /**
     * setOrdersStatusSelected
     */
    public function setArticleCodSelected(String $articleCodOptions)
    {
        $this->unsetArticleCodSelected(); 
        UserOption::setUserOptionNewUser("article_cod", $articleCodOptions, $this);
        return true;
    }

     /**
     * Set for [[ActiveOrder]].
     *
     * @return bool
     */
    public function unsetArticleCodSelected()
    {
        $articleCodOptions = UserOption::find()->where(['user_id' => Yii::$app->user->id, 'field' => 'article_cod'])->one();
        if($articleCodOptions){
            $articleCodOptions->delete();
        }        
        return true;
    }
    
    /**
     * getOrdersStatusSelected
     */
    public function getArticleCodSelected()
    {
        return (UserOption::getUserOption("article_cod", $this))? UserOption::getUserOption("article_cod", $this) : "";
    }

    /**
     * getStartDateSelected
     */
    public function getCategorySelected()
    {
        return (UserOption::getUserOption("category_selected", $this))? UserOption::getUserOption("category_selected", $this) : "1";
    }

    /**
     * setOrderEndDateSelected
     */
    public function setCategorySelected(String $categorySelected)
    {
        $this->unsetCategorySelected(); 
        UserOption::setUserOptionNewUser("category_selected", $categorySelected, $this);
        return true;
    }

    public function unsetCategorySelected()
    {
        $categoryOptions = UserOption::find()->where(['user_id' => Yii::$app->user->id, 'field' => 'category_selected'])->one();
        if($categoryOptions){
            $categoryOptions->delete();
        }        
        return true;
    }

    public static function deleteAllFilter(){
        $filters = UserOption::find()
                ->where(['user_id' => Yii::$app->user->id])
                ->andWhere(['<>','field', 'active_order_id'])
                ->andWhere(['<>','field', 'customer_cod'])->all();
       
        foreach($filters as $filter){
            $filter->delete();
        }
        return true;
    }
}