<?php

namespace bitcream\gmvricambi\custom\common\models;

use Yii;
/**
 * This is the model class for table "{{%GMVArticlePriceList}}".
 *
 */
class GMVArticlePriceList extends base\GMVArticlePriceList
{
    public static function currentUserPriceList($articleCod, $priceListCod = "0"){
        $customerCod = CustomerUser::getCurrentUser()->customerCod;

        $articlePrice = GMVArticlePriceList::find()
                            ->where([
                                        'price_list_cod' => $priceListCod,
                                        'article_cod' => $articleCod,
                                        'customer_cod' => [$customerCod, '**']
                                    ])
                            ->orderBy(['customer_cod' => SORT_DESC])
                            ->one();

        // foreach($articlePrices as $articlePrice){
        //     $selectedArticlePrice = $articlePrice;
        // }
        return $articlePrice;
    }

}
