<?php

namespace bitcream\gmvricambi\custom\console\controllers;

use Yii;
use yii\console\Controller;
use yii\console\ExitCode;

/**
 * Manage users module permissions
 */
class RbacController extends Controller
{
    public $defaultAction ="init";

   /**
     * Init users permissions and assign the permissions to role
     */

    public function actionInit()
    {

        $auth = Yii::$app->authManager;
        // $auth->removeAll();
        $rule = $auth->getRule('ViewOwnContent');
        if( empty($rule)){
        $rule = new \bitcream\gmvricambi\custom\common\models\ViewOwnContent;
        $auth->add($rule);
        }


        // add the "updateOwnPost" permission and associate the rule with it.
        $ViewOwnContent = $auth->getPermission('ViewOwnContent');
        if( empty($ViewOwnContent)){
              $ViewOwnContent  = $auth->createPermission('ViewOwnContent');
              $ViewOwnContent->description = 'visualizza solo il mio conetnte';
              $ViewOwnContent->ruleName = $rule->name;
              $auth->add($ViewOwnContent);
        };

        // // add "viewStoreManagerMenu" permission
        // $viewStoreMenu = $auth->getPermission('viewStoreMenu');
        // if( empty($viewStoreMenu)){
        //     $viewStoreMenu = $auth->createPermission('viewStoreMenu');
        //     $viewStoreMenu->description = 'visualizza store menu';
        //     $auth->add($viewStoreMenu);
        // };
        // add "viewSysadminMenu" permission
        $viewSysadminMenu = $auth->getPermission('viewSysadminMenu');
        if( empty($viewSysadminMenu)){
            $viewSysadminMenu = $auth->createPermission('viewSysadminMenu');
            $viewSysadminMenu->description = 'permesso per menu di sistema';
            $auth->add($viewSysadminMenu);
        }

        $viewApplicationsItems = $auth->getPermission('viewApplicationsItems');
        if( empty($viewApplicationsItems)){
            $viewApplicationsItems = $auth->createPermission('viewApplicationsItems');
            $viewApplicationsItems->description = 'permesso per menu di applicazione clienti';
            $auth->add($viewApplicationsItems);
        }

        // $storeManager = $auth->getRole('storeManager');
        // if( empty($storeManager)){
        //     $storeManager = $auth->createRole('storeManager');
        //     $storeManager->description = 'ruolo store manager';
        //     $auth->add($storeManager);
        // }

        $viewPartnerItems = $auth->getPermission('viewPartnerItems');
        if( empty($viewPartnerItems)){
            $viewPartnerItems = $auth->createPermission('viewPartnerItems');
            $viewPartnerItems->description = 'permesso per menu per clienti';
            $auth->add($viewPartnerItems);
        }

        $CreateAllOrder = $auth->getPermission('CreateAllOrder');
        if( empty($CreateAllOrder)){
            $CreateAllOrder = $auth->createPermission('CreateAllOrder');
            $CreateAllOrder->description = 'permesso per creare da ordini da qualsiasi utente';
            $auth->add($CreateAllOrder);
        }
        $UpdateAllOrder = $auth->getPermission('UpdateAllOrder');
        if( empty($UpdateAllOrder)){
            $UpdateAllOrder = $auth->createPermission('UpdateAllOrder');
            $UpdateAllOrder->description = 'permesso per modificare ordine';
            $auth->add($UpdateAllOrder);
        }
        $ViewAllOrder = $auth->getPermission('ViewAllOrder');
        if( empty($ViewAllOrder)){
            $ViewAllOrder = $auth->createPermission('ViewAllOrder');
            $ViewAllOrder->description = 'permesso per vedere ordini';
            $auth->add($ViewAllOrder);
        }
        $DeleteAllOrder = $auth->getPermission('DeleteAllOrder');
        if( empty($DeleteAllOrder)){
            $DeleteAllOrder = $auth->createPermission('DeleteAllOrder');
            $DeleteAllOrder->description = 'permesso per cancellare tutti ordini';
            $auth->add($DeleteAllOrder);
        }
        $adminRole = $auth->getRole('admin');
        if($adminRole){
            if(!$auth->hasChild($adminRole, $ViewOwnContent)){
                $auth->addChild($adminRole, $ViewOwnContent);
            }
            if(!$auth->hasChild($adminRole, $viewApplicationsItems)){
                $auth->addChild($adminRole, $viewApplicationsItems);
            }
            if(!$auth->hasChild($adminRole, $viewSysadminMenu)){
                $auth->addChild($adminRole, $viewSysadminMenu);
            }
            if(!$auth->hasChild($adminRole, $CreateAllOrder)){
                $auth->addChild($adminRole, $CreateAllOrder);
            }
            if(!$auth->hasChild($adminRole, $UpdateAllOrder)){
                $auth->addChild($adminRole, $UpdateAllOrder);
            }
            if(!$auth->hasChild($adminRole, $ViewAllOrder)){
                $auth->addChild($adminRole, $ViewAllOrder);
            }
            if(!$auth->hasChild($adminRole, $DeleteAllOrder)){
                $auth->addChild($adminRole, $DeleteAllOrder);
            }
        };

        return ExitCode::OK;
    }

}
