<?php

namespace bitcream\gmvricambi\custom\api\models;

use Yii;
use bitcream\gmvricambi\custom\common\models\ProductImage;
use bitcream\gmvricambi\custom\backend\models\Product;
use bitcream\gmvricambi\custom\common\models\CustomerUser;
/**
 * This is the model class for table "{{%gmv-customer}}".
 *
 */
class GMVArticle extends \bitcream\gmvricambi\custom\common\models\GMVArticle
{
    public function fields(){
        return [
            'article_cod',
            //'description',
            //'family',
            'unit_of_measure_cod',
            'unit_of_measure',
            //'weight',
            //'packaging_code',
            "cover_image" => "coverImage",
            'article_description' => 'product'
        ];
    }

    // /**
    //  * Gets query for [[Product]].
    //  *
    //  * @return \yii\db\ActiveQuery
    //  */
    // public function getProducts()
    // {
    //     return $this->hasMany(Product::className(), ['article_cod' => 'article_cod']);
    // }

    /**
     * Gets query for [[Product]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getProduct()
    {
        $products = Product::find()->where(['article_cod' => $this->article_cod, 'status' => '30'])->all();
        if(!empty($products)){
            $customerUser = CustomerUser::findOne(Yii::$app->user->id);
        }         
        if(!empty($customerUser)){
            $language = $customerUser->customer->language;
        }
        if(!empty($language)){
            return Product::getTranslation($language, $this->article_cod, $products); 
        }
        return $this->description;
    }


    public function getCoverImage(){
        return ProductImage::find()->where(['article_cod' => $this->article_cod])->one();
    }

}
