<?php

namespace bitcream\gmvricambi\custom\api\models;

use Yii;
use bitcream\gmvricambi\custom\common\models\CustomerUser;
use yii\helpers\Url;

/**
 * This is the model class for table "{{%order}}".
 *
 */
class Order extends \bitcream\gmvricambi\custom\common\models\Order
{
    public function fields(){
        return [
            'id',
            'name',
            'slug',
            'order_date',
            'business_name',
            'address',
            'locality',
            'postal_code',
            'province' => 'provinceCod',
            'country' => 'countryCod',
            'shipping_address' => 'shippingAddress',
            'delivery_date',
            'payment_method',
            'payment_information',
            'total',
            'order_status',
            'status',
            'order_reference',
            'plant_reference',
            'GMV_PK_Insert_Date',
            'GMV_PK',
            'customer' => 'customerCod',            
            'items' => 'orderItems',      
            'link' => 'link'
        ];
    }

     /**
     * Gets query for [[CustomerCod]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCustomerCod()
    {
        return $this->hasOne(GMVCustomer::className(), ['customer_cod' => 'customer_cod'])->inverseOf('orders');
    }

    /**
     * Gets query for [[OrderCod]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getOrderCod()
    {
        return $this->hasOne(GMVOrder::className(), ['plant_cod' => 'order_cod'])->inverseOf('orders');
    }

    /**
     * Gets query for [[OrderItems]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getOrderItems()
    {
        return OrderItem::find()->where(['status' => '30', 'order_id' => $this->id])->all();
    }

    /**
     * Gets query for [[OrderItems]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getShippingAddress()
    {
        $customerUser = CustomerUser::findOne(Yii::$app->user->id);
        return GMVShippingAddress::find()->where(['customer_cod' => $customerUser->customerCod, 'shipping_address_cod' => $this->shipping_address]);
    }

    /**
     * Gets query for [[province_cod]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getProvinceCod()
    {
        return $this->hasOne(GMVProvince::className(), ['province_cod' => 'province']);
    }

    /**
     * Gets query for [[GMVCountry]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCountryCod()
    {
        return $this->hasOne(GMVCountry::className(), ['country_cod' => 'country']);
    }

    /**
     * Gets query for [[ActiveOrder]].
     *
     * @return Order
     */
    public function getActiveOrder()
    {
        $active_order = UserOption::getUserOption("active_order_id", $this);

        return  Order::find()->where(['id' => $active_order])->one();   
    }

    public function getLink(){
        return [
            $this->linkUpdateOrder,
            $this->linkViewOrder,
            $this->linkConfirmOrder,
        ];
    }

    public function getLinkUpdateOrder(){
        return [
            'name' => 'edit',
            'url' => Yii::$app->params['backendUrl'].'/custom/order-customer/update?id='.$this->id,
        ];        
    }

    public function getLinkDeleteOrder(){
        return [
            'name' => 'delete',
            'url' => Yii::$app->params['backendUrl'].'/custom/order-customer/delete?id='.$this->id,
        ];
    }
    public function getLinkViewOrder(){
        return [
            'name' => 'view',
            'url' => Yii::$app->params['backendUrl'].'/custom/order-customer/view?id='.$this->id,
        ];
    }
    public function getLinkConfirmOrder(){
        return [
            'name' => 'confirm',
            'url' => Yii::$app->params['backendUrl'].'/custom/order-customer/view?id='.$this->id."#confirm",
        ];
    }
    
}
