<?php

namespace bitcream\gmvricambi\custom\backend\controllers;

use Yii;
use bitcream\gmvricambi\custom\backend\models\GMVArticle;
use bitcream\gmvricambi\custom\backend\models\GMVArticleCustomerSearch;
use bitcream\gmvricambi\custom\backend\models\Product;
use bitcream\gmvricambi\custom\backend\models\ProductImage;
use bitcream\gmvricambi\custom\backend\models\OrderItem;
use bitcream\gmvricambi\custom\common\models\CustomerUser;

use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * GmvArticleController implements the CRUD actions for GMVArticle model.
 */
class GmvArticleCustomerController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all GMVArticle models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new GMVArticleCustomerSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
        $customerUser = CustomerUser::findOne(Yii::$app->user->id);
        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
            'customerUser' => $customerUser,
            'categorySelected' => $customerUser->getCategorySelected()
        ]);
    }

   
    /**
     * Displays a single GMVArticle model.
     * @param string $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($article_cod)
    {
        $orderItem = new OrderItem();
        $GMVArticle = $this->findModel($article_cod);
        $attributeView = $GMVArticle->getAttributeTranslation();

        return $this->render('view', [
            'model' => $this->findModel($article_cod),
            'orderItem' => $orderItem,
            'attributeView' => $attributeView,
            'productImage' => ProductImage::getProductImage($article_cod),
        ]);
    }

    public function actionAddProductToOrder(){

        $orderItem = new OrderItem();
        $result = $orderItem->addOrderItem(Yii::$app->request->post()['GMVArticle'], Yii::$app->request->post()['OrderItem']);    
        
        if($result['result']){
            $response = Yii::$app->response;
            $response->format = \yii\web\Response::FORMAT_JSON;
            $response->data = $result;
            $response->statusCode = 200;
        }else{
            $response->data = false;
        }

        return $response;
    }

    public function actionSetArticleCod($article_cod){
        $customerUser = CustomerUser::findOne(Yii::$app->user->id);
        $customerUser->setArticleCodSelected($article_cod);
        return $this->redirect(['index']);
    }

    public function actionResetArticleCod(){
        $customerUser = CustomerUser::findOne(Yii::$app->user->id);
        $customerUser->unsetArticleCodSelected();
        return $this->redirect(['index']);
    }

    public function actionSetCategory($category){
        $customerUser = CustomerUser::findOne(Yii::$app->user->id);
        $customerUser->setCategorySelected($category);
        return $this->redirect(['index']);
    }

    /**
     * Finds the GMVArticle model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param string $id
     * @return GMVArticle the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = GMVArticle::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('gmv', 'The requested page does not exist.'));
    }
}
