<?php

use yii\widgets\Breadcrumbs;
use yii\helpers\Html;
use emberware\evidia\datatable\common\models\DataTableCustom;

?>
<div class="datatable">
        <?=
        DataTableCustom::widget([
            'dataProvider' => $dataProvider,
            'id' => 'product-component-table',
            // 'filterModel' => $filterModel,
            // 'searchProvider' => $searchProvider,
            'columns' => [
                ['attribute'=>Yii::t('gmv', 'Name'),
                    'format'=>'raw',
                    'value' => function ($model, $key, $index, $column) use ($assembledArticle)
                    {return Html::a($model->name, ['product-component/view','id'=>$model->id, 'assembledArticle' => $assembledArticle->article_cod]);}
                ],
                [
                    'format'=>'raw',
                    'label' => 'Azioni',
                    'value' => function ($model, $key, $index, $column) use ($assembledArticle)
                    {

                        $htmlButtons = "";
                        $htmlButtons .= " ".Html::a(Yii::t('gmv', '<i class="fa fa-pencil"></i>'), ['product-component/update', 'id'=> $model->id, 'assembledArticle' => $assembledArticle->article_cod], ['class' => 'btn btn-warning action-button']);
                        $htmlButtons .= " ".Html::a(Yii::t('gmv', '<i class="fa fa-trash"></i>'), ['product-component/delete', 'id'=> $model->id, 'assembledArticle' => $assembledArticle->article_cod], [
                                'class' => 'btn btn-danger action-button',
                                'data' => [
                                    'confirm' => Yii::t('gmv','Are you sure you want to delete this product component?'),
                                    'method' => 'post',
                                ]
                        ]);
                        return $htmlButtons;
                    }
                ]
            ],
            'clientOptions' => [
                "responsive"=>true,
                "language" => [
                    "url" => Yii::t('gmv',"//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json")
                ]
            ]
        ]);
    ?>
</div>