<?php

use yii\widgets\Breadcrumbs;
use yii\helpers\Html;
use emberware\evidia\datatable\common\models\DataTableCustom;

?>
<div class="datatable">
        <?=
        DataTableCustom::widget([
            'dataProvider' => $dataProvider,
            'id' => 'orderitem-table',
            // 'filterModel' => $filterModel,
            // 'searchProvider' => $searchProvider,
            'columns' => [
                'article_cod',
                'name',
                [
                    'attribute'=>Yii::t('gmv', 'Quantity'),
                    'format'=>'raw',
                    'value' => function($data)
                    {
                        if(!empty($data->dimension)){
                            return $data->quantity."x".$data->dimension." ".$data->gmvArticle->unit_of_measure_cod;
                        }
                        return $data->quantity;
                    }
                ],
                'product_price',
                'total_price',
                [
                    'format'=>'raw',
                    'label' => 'Azioni',
                    'value' => function ($model, $key, $index, $column) use ($order)
                    {
                        if($order->showActionOrderItem()){
                            return Html::a("<i class='fa fa-trash-o'></i>", ['order-item/delete', 'id'=> $model->id],                    
                            [
                                'class' => 'btn btn-danger action-button',
                                'data' => [
                                    'confirm' => Yii::t('gmv','Are you sure you want to delete this order item?'),
                                    'method' => 'post',
                                ]
                            ]);
                        }else{
                            return "";
                        }
                        
                    }
                ]
            ],
            'clientOptions' => [
                "responsive"=>true,
                "language" => [
                    "url" => Yii::t('gmv',"//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json")
                ]
            ]
        ]);
    ?>
</div>