<?php 
use yii\bootstrap\Modal;
use kartik\select2\Select2;
use yii\helpers\ArrayHelper;
use yii\widgets\ActiveForm;
use yii\helpers\Html;

Modal::begin([
            'header' => '<h2 class="modal-title">'.Yii::t('gmv', 'Are you sure to confirm the order?').'</h2>',
            'id'     => 'modal-confirm',
        ]); ?>

            <?php $form = ActiveForm::begin([
                    'action' => ['confirm', 'id' => $model->id],
                    'method' => 'post', 
                ]
            ); ?>

                <h4><?=Yii::t('gmv','Once the order has been confirmed, you not be able to change the order!')?></h4><br>
                <div class="row">
                    <div class="col-sm-6">
                        <b><?=Yii::t('gmv','Shipping address')?></b>
                        <br><p><?=$model->address.' '.$model->province.' '.$model->postal_code?></p>
                    </div>
                    <div class="col-sm-6">
                        <b><?=Yii::t('gmv','Delivery date')?></b>
                        <br><p><?=$model->delivery_date?></p>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-12">
                        <h3><?=Yii::t('gmv','Total: ').$model->total?>€</h3>
                        <b><?=Yii::t('gmv','Select Payment Method')?></b><br>
                        <?=  Select2::widget([
                            'name' => 'payment_method',
                            'data' => ArrayHelper::map($paymentMethods,'payment_cod','description'),
                            'options' => [
                                'placeholder' => Yii::t('gmv','Select payment method'),
                                'multiple' => false
                            ],
                        ]);               
                        ?>
                    </div>
                </div>
                <br>
                <div class="right-align">
                    <?=Html::submitButton(Yii::t('gmv','Confirm'), ['class' => 'btn btn-success', 'id' => 'confirm'])?>
                </div>

            <?php ActiveForm::end(); ?>

        <?php Modal::end(); ?>