<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use bitcream\gmvricambi\custom\common\widget\OrderActionWidget;
use yii\bootstrap\Modal;
use kartik\select2\Select2;
use yii\helpers\ArrayHelper;
use yii\widgets\ActiveForm;

/* @var $this yii\web\View */
/* @var $model bitcream\gmvricambi\custom\backend\models\Order */
bitcream\gmvricambi\custom\backend\Asset::register($this);
$this->title = $model->name;
$this->params['breadcrumbs'][] = ['label' => Yii::t('gmv', 'Orders'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="order-view">

    <h1><?= Html::encode($this->title) ?></h1>
    <?php
        echo OrderActionWidget::widget(['status' => $status, 'model' => $model, 'activeOrder' => $customerUser->getActiveOrder(), 'categoryMessage' => 'gmv']);
    ?>

    <?php if(!empty($model->orderItems)){        
            echo $this->render('_modal_confirm',[
                'model' => $model,
                'paymentMethods' => $paymentMethods,
            ]);
        }else{
            echo $this->render('_modal_empty');
    }?>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'name',
            'order_date',
            'business_name',
            'address',
            'locality',
            'postal_code',
            'country',
            'shipping_address',
            'delivery_date',
            'payment_method',
            'customer_cod',
            'order_status',
        ],
    ]) ?>
    <br>
    <hr>

    <?php if($model->checkProcessing()){ 
            if(isset($customerUser->getActiveOrder()->id) && ($customerUser->getActiveOrder()->id  == $model->id)){ 
                echo Html::a(Yii::t('gmv','Add products to order'), ['gmv-article-customer/index'], ['class' => 'btn btn-success']);
            }else{
                echo Html::a(Yii::t('gmv','Add products to order'), ['activate-add-product-order', 'id' => $model->id], ['class' => 'btn btn-success']);
            }
        } ?>
    <?= $this->render('_datatable-orderitem',[
            'searchModel' => $searchModelOrderItem,
            'dataProvider' => $dataProviderOrderItem,
            'order' => $model,
    ]) ?>
    

</div>
