<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use kartik\select2\Select2;
use bitcream\gmvricambi\custom\common\models\Order;
use kartik\datecontrol\DateControl;
use bitcream\gmvricambi\custom\common\widget\OrderWidget;

/* @var $this yii\web\View */
/* @var $searchModel bitcream\gmvricambi\custom\backend\models\OrderSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */
\bitcream\gmvricambi\custom\backend\Asset::register($this);
$this->title = Yii::t('gmv', 'Orders');
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="order-index">

    <?= $this->render('_breadcrumb',[
        'searchModel' => $searchModel,
        'dataProvider' => $dataProvider,
    ]) ?>  
    <div class="separator-breadcrumb">/</div>
    <?= OrderWidget::widget(['orderStatusSelected' => $orderStatusSelected]); ?>
   
    <h1><?= Html::encode($this->title) ?></h1>
   
    <p>
        <?= Html::a(Yii::t('gmv', 'Create Order'), ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?php $form = ActiveForm::begin([
        'action' => ['set-filter'],
        'method' => 'get'
    ]) ?>
        <div class="row">
            <div class="col-lg-3 col-md-4 col-sm-4">
                <label class="control-label"><?=Yii::t('gmv', 'Destination Order')?></label>
                <?= Select2::widget(['name' => 'locality', 'value' => $customerUser->getDestinationSelected(),'id' => 'locality', 'attribute' => 'locality', 'data' => Order::localityList($customerUser)]) ?>
            </div>
            <div class="col-lg-3 col-md-4 col-sm-4">
            <?= Html::label("Start date");
                echo DateControl::widget([
                    'name'=>'startDate', 
                    'id' => 'start-date',
                    'value'=> $customerUser->getStartDateSelected(),
                    'type' => 'date',
                    'saveTimezone' => 'Europe/Amsterdam',
                    'displayTimezone' => 'Europe/Amsterdam',
                    'displayFormat' => 'php:d/m/Y',
                    'saveFormat' => 'php:U',
                    'autoWidget' => true,
                    'widgetOptions' => [
                        'pluginOptions' => [
                            'autoclose' => true,
                            'format' => 'php:d/m/Y'
                        ]
                    ],
                ]); ?>
               <div id="error-start-date" class="error"></div>
            </div>
            <div class="col-lg-3 col-md-4 col-sm-4">
            <?= Html::label("End date");
                echo DateControl::widget([
                    'name'=>'endDate', 
                    'id' => 'end-date',
                    'value'=> $customerUser->getEndDateSelected(),
                    'type' => 'date',
                    'saveTimezone' => 'Europe/Amsterdam',
                    'displayTimezone' => 'Europe/Amsterdam',
                    'displayFormat' => 'php:d/m/Y',
                    'saveFormat' => 'php:U',
                    'autoWidget' => true,
                    'widgetOptions' => [
                        'pluginOptions' => [
                            'autoclose' => true,
                            'format' => 'php:d/m/Y'
                        ]
                    ],
                ]); ?>
                <div id="error-end-date" class="error"></div>
            </div>
            <br>
        </div>
        <br>
        <?= Html::submitButton(Yii::t('gmv', 'Filter'), ['class' => 'btn btn-success']) ?>
        <?= Html::a(Yii::t('gmv', 'Reset filter'), ['/custom/order/reset-filter'], ['class'=>'btn btn-primary', 'id'=>'reset-filter']) ?>
    <?php ActiveForm::end(); ?>
    <br>

    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <?= $this->render('_datatable',[
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
    ]) ?>


</div>
