<?php

namespace bitcream\gmvricambi\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%GMVArticleFamilyDiscount}}".
 *
 * @property string $customer_cod
 * @property string $family
 * @property float|null $discount_1
 * @property float|null $discount_2
 * @property float|null $discount_3
 * @property float|null $discount_4
 * @property float|null $discount_5
 */
class GMVArticleFamilyDiscount extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%GMV_article_family_discount}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['customer_cod', 'family'], 'required'],
            [['discount_1', 'discount_2', 'discount_3', 'discount_4', 'discount_5'], 'number'],
            [['customer_cod'], 'string', 'max' => 6],
            [['family'], 'string', 'max' => 3],
            [['customer_cod', 'family'], 'unique', 'targetAttribute' => ['customer_cod', 'family']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'customer_cod' => Yii::t('gmv', 'Customer Cod'),
            'family' => Yii::t('gmv', 'Family'),
            'discount_1' => Yii::t('gmv', 'Discount 1'),
            'discount_2' => Yii::t('gmv', 'Discount 2'),
            'discount_3' => Yii::t('gmv', 'Discount 3'),
            'discount_4' => Yii::t('gmv', 'Discount 4'),
            'discount_5' => Yii::t('gmv', 'Discount 5'),
        ];
    }
}
