<?php

namespace bitcream\gmvricambi\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%order}}".
 *
 * @property int $id
 * @property string|null $name
 * @property string|null $slug
 * @property string|null $order_date
 * @property string|null $business_name
 * @property string|null $address
 * @property string|null $locality
 * @property string|null $postal_code
 * @property string|null $province
 * @property string|null $country
 * @property string|null $delivery_date
 * @property string|null $payment_method
 * @property string|null $payment_information
 * @property float|null $total
 * @property string|null $order_status
 * @property int|null $status
 * @property string|null $created_at
 * @property int|null $created_user_id
 * @property string|null $updated_at
 * @property int|null $updated_user_id
 * @property string|null $customer_cod
 * @property string|null $GMV_PK_Insert_Date
 * @property string|null $GMV_PK
 * @property string|null $shipping_address
 * @property string|null $order_reference
 * @property string|null $plant_reference
 *
 * @property GMVCustomer $customerCod
 * @property OrderItem[] $orderItems
 */
class Order extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%order}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['total'], 'number'],
            [['status', 'created_user_id', 'updated_user_id'], 'integer'],
            [['name', 'slug', 'order_date', 'business_name', 'address', 'locality', 'country', 'delivery_date', 'payment_method', 'payment_information', 'order_status', 'created_at', 'updated_at', 'GMV_PK_Insert_Date', 'GMV_PK', 'order_reference', 'plant_reference'], 'string', 'max' => 255],
            [['postal_code'], 'string', 'max' => 10],
            [['province'], 'string', 'max' => 5],
            [['customer_cod'], 'string', 'max' => 6],
            [['shipping_address'], 'string', 'max' => 3],
            [['customer_cod'], 'exist', 'skipOnError' => true, 'targetClass' => GMVCustomer::className(), 'targetAttribute' => ['customer_cod' => 'customer_cod']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('gmv', 'ID'),
            'name' => Yii::t('gmv', 'Name'),
            'slug' => Yii::t('gmv', 'Slug'),
            'order_date' => Yii::t('gmv', 'Order Date'),
            'business_name' => Yii::t('gmv', 'Business Name'),
            'address' => Yii::t('gmv', 'Address'),
            'locality' => Yii::t('gmv', 'Locality'),
            'postal_code' => Yii::t('gmv', 'Postal Code'),
            'province' => Yii::t('gmv', 'Province'),
            'country' => Yii::t('gmv', 'Country'),
            'delivery_date' => Yii::t('gmv', 'Delivery Date'),
            'payment_method' => Yii::t('gmv', 'Payment Method'),
            'payment_information' => Yii::t('gmv', 'Payment Information'),
            'total' => Yii::t('gmv', 'Total'),
            'order_status' => Yii::t('gmv', 'Order Status'),
            'status' => Yii::t('gmv', 'Status'),
            'created_at' => Yii::t('gmv', 'Created At'),
            'created_user_id' => Yii::t('gmv', 'Created User ID'),
            'updated_at' => Yii::t('gmv', 'Updated At'),
            'updated_user_id' => Yii::t('gmv', 'Updated User ID'),
            'customer_cod' => Yii::t('gmv', 'Customer Cod'),
            'GMV_PK_Insert_Date' => Yii::t('gmv', 'Gmv  Pk  Insert  Date'),
            'GMV_PK' => Yii::t('gmv', 'Gmv  Pk'),
            'shipping_address' => Yii::t('gmv', 'Shipping Address'),
            'order_reference' => Yii::t('gmv', 'Order Reference'),
            'plant_reference' => Yii::t('gmv', 'Plant Reference'),
        ];
    }

    /**
     * Gets query for [[CustomerCod]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCustomerCod()
    {
        return $this->hasOne(GMVCustomer::className(), ['customer_cod' => 'customer_cod']);
    }

    /**
     * Gets query for [[OrderItems]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getOrderItems()
    {
        return $this->hasMany(OrderItem::className(), ['order_id' => 'id']);
    }
}
