<?php

namespace bitcream\gmvricambi\custom\backend\controllers;

use Yii;
use bitcream\gmvricambi\custom\backend\models\GMVAgent;
use bitcream\gmvricambi\custom\backend\models\GMVAgentSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use bitcream\gmvricambi\custom\common\models\CustomerUser;

/**
 * GmvAgentController implements the CRUD actions for GMVAgent model.
 */
class GmvAgentController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all GMVAgent models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new GMVAgentSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single GMVAgent model.
     * @param string $customer_cod
     * @param string $agent_cod
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($customer_cod, $agent_cod)
    {
        return $this->render('view', [
            'model' => $this->findModel($customer_cod, $agent_cod),
        ]);
    }

    /**
     * Creates a new GMVAgent model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new GMVAgent();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'customer_cod' => $model->customer_cod, 'agent_cod' => $model->agent_cod]);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing GMVAgent model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param string $customer_cod
     * @param string $agent_cod
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($customer_cod, $agent_cod)
    {
        $model = $this->findModel($customer_cod, $agent_cod);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'customer_cod' => $model->customer_cod, 'agent_cod' => $model->agent_cod]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing GMVAgent model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param string $customer_cod
     * @param string $agent_cod
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($customer_cod, $agent_cod)
    {
        $this->findModel($customer_cod, $agent_cod)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the GMVAgent model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param string $customer_cod
     * @param string $agent_cod
     * @return GMVAgent the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($customer_cod, $agent_cod)
    {
        if (($model = GMVAgent::findOne(['customer_cod' => $customer_cod, 'agent_cod' => $agent_cod])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('gmv', 'The requested page does not exist.'));
    }

    /**
     * Displays a single GMVCustomer model.
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionAgentInfo()
    {
        // Yii::$app->user->id;
        $customerUser = CustomerUser::findOne(Yii::$app->user->id);
        $agent = GMVAgent::findOne(['customer_cod' => $customerUser->customerCod]);
        return $this->render('agent_info', [
            'model' => $agent,
        ]);
    }
}
