<?php

namespace bitcream\gmvricambi\custom\backend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use bitcream\gmvricambi\custom\backend\models\GMVArticlePriceList;

/**
 * GMVArticlePriceListSearch represents the model behind the search form of `bitcream\gmvricambi\custom\backend\models\GMVArticlePriceList`.
 */
class GMVArticlePriceListSearch extends GMVArticlePriceList
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['price_list_cod', 'customer_cod', 'article_cod', 'currency'], 'safe'],
            [['quantity', 'price', 'discount_1', 'discount_2', 'discount_3', 'discount_4', 'discount_5'], 'number'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = GMVArticlePriceList::find()->limit(50);

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        foreach($params as $key => $value){
            // grid filtering conditions
            $query->andFilterWhere([
                $key => $value,
            ]);
        }

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'quantity' => $this->quantity,
            'price' => $this->price,
            'discount_1' => $this->discount_1,
            'discount_2' => $this->discount_2,
            'discount_3' => $this->discount_3,
            'discount_4' => $this->discount_4,
            'discount_5' => $this->discount_5,
        ]);

        $query->andFilterWhere(['like', 'price_list_cod', $this->price_list_cod])
            ->andFilterWhere(['like', 'customer_cod', $this->customer_cod])
            ->andFilterWhere(['like', 'article_cod', $this->article_cod])
            ->andFilterWhere(['like', 'currency', $this->currency]);

        return $dataProvider;
    }
}
