<?php

namespace bitcream\gmvricambi\custom\common\models;

use Yii;
/**
 * This is the model class for table "{{%GMV_customer}}".
 *
 */
class GMVCustomer extends base\GMVCustomer
{
    /**
     * @inheritdoc $primaryKey
     */
    public static function primaryKey()
    {
        return ["customer_cod"];
    }

    /**
     * Funzione che restituisce i metodi di pagamento
     */
    public function getPaymentMethods($total_order){
        $paymentMethodList = ['A01', 'B10'];
        if($total_order > Yii::$app->params['minimum_threshold']){
            array_push($paymentMethodList, $this->payment_term_cod);
        }
        return GMVPaymentMethod::findAll(['payment_cod' => $paymentMethodList]);
    }

    public function checkPaymentMethod($paymentMethodCod, $total_order){
        foreach($this->getPaymentMethods($total_order) as $paymentMethod){
            if($paymentMethod->payment_cod == $paymentMethodCod){
                return true;
            }
        }
        return false;
    }

    public function checkRating(){
        if($this->rating_cod != "D"){
            return true;
        }
        return false;
    }

    public static function getLanguage(){
        $customerUser = CustomerUser::findOne(Yii::$app->user->id);
        $nationCod = trim($customerUser->customer->nation_cod);
        foreach (Yii::$app->params['language'] as $key => $value){
            if($key == $nationCod){
                return $value;
            }
        }
        return "it";
    }

    public static function getLanguageBackend(){
        if(Yii::$app->user->id){
            $customerUser = CustomerUser::findOne(Yii::$app->user->id);
            $nationCod = trim($customerUser->customer->nation_cod);
            foreach (Yii::$app->params['language-backend'] as $key => $value){
                if($key == $nationCod){
                    return $value;
                }
            }
        }       
        return "it-IT";
    }

    public static function setCurrentUserLanguage($event){
        $language = GMVCustomer::getLanguageBackend();
        if($language){
            Yii::$app->language = $language;
            Yii::$app->sourceLanguage = $language;
        }
    }
}
