<?php

namespace bitcream\gmvricambi\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%GMV_spare_parts_for_order}}".
 *
 * @property string $plant_cod
 * @property string|null $plant_reference
 * @property string $order_reference
 * @property string $article_cod
 * @property string $description
 */
class GMVSparePartsForOrder extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%GMV_spare_parts_for_order}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['plant_cod', 'order_reference', 'article_cod', 'description'], 'required'],
            [['plant_cod'], 'string', 'max' => 10],
            [['plant_reference', 'order_reference'], 'string', 'max' => 25],
            [['article_cod'], 'string', 'max' => 20],
            [['description'], 'string', 'max' => 35],
            [['plant_cod'], 'unique'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'plant_cod' => Yii::t('gmv', 'Plant Cod'),
            'plant_reference' => Yii::t('gmv', 'Plant Reference'),
            'order_reference' => Yii::t('gmv', 'Order Reference'),
            'article_cod' => Yii::t('gmv', 'Article Cod'),
            'description' => Yii::t('gmv', 'Description'),
        ];
    }
}
