<?php

namespace bitcream\gmvricambi\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%product_component}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%GMV_articles_category}}`
 */
class M211008114902AddCategoryIdColumnToProductComponentTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%product_component}}', 'category_id', $this->integer(11)->notNull());

        // creates index for column `category_id`
        $this->createIndex(
            '{{%idx-product_component-category_id}}',
            '{{%product_component}}',
            'category_id'
        );

        // add foreign key for table `{{%GMV_articles_category}}`
        $this->addForeignKey(
            '{{%fk-product_component-category_id}}',
            '{{%product_component}}',
            'category_id',
            '{{%GMV_articles_category}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%GMV_articles_category}}`
        $this->dropForeignKey(
            '{{%fk-product_component-category_id}}',
            '{{%product_component}}'
        );

        // drops index for column `category_id`
        $this->dropIndex(
            '{{%idx-product_component-category_id}}',
            '{{%product_component}}'
        );

        $this->dropColumn('{{%product_component}}', 'category_id');
    }
}
